/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.mutateevent.MapToListProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="map_to_list", pluginType=Processor.class, pluginConfigurationType=MapToListProcessorConfig.class)
public class MapToListProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(MapToListProcessor.class);
    private final MapToListProcessorConfig config;
    private final ExpressionEvaluator expressionEvaluator;
    private final Set<String> excludeKeySet = new HashSet<String>();

    @DataPrepperPluginConstructor
    public MapToListProcessor(PluginMetrics pluginMetrics, MapToListProcessorConfig config, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics);
        this.config = config;
        this.expressionEvaluator = expressionEvaluator;
        this.excludeKeySet.addAll(config.getExcludeKeys());
        if (config.getMapToListWhen() != null && !expressionEvaluator.isValidExpressionStatement(config.getMapToListWhen()).booleanValue()) {
            throw new InvalidPluginConfigurationException(String.format("map_to_list_when %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", config.getMapToListWhen()));
        }
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        for (Record<Event> record : records) {
            Event recordEvent = (Event)record.getData();
            try {
                if (this.config.getMapToListWhen() != null && !this.expressionEvaluator.evaluateConditional(this.config.getMapToListWhen(), recordEvent).booleanValue()) continue;
                try {
                    Map<String, Object> sourceMap = this.getSourceMap(recordEvent);
                    if (this.config.getConvertFieldToList()) {
                        ArrayList<List<Object>> targetNestedList = new ArrayList<List<Object>>();
                        for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
                            if (this.excludeKeySet.contains(entry.getKey())) continue;
                            targetNestedList.add(Arrays.asList(entry.getKey(), entry.getValue()));
                        }
                        this.removeProcessedFields(sourceMap, recordEvent);
                        recordEvent.put(this.config.getTarget(), targetNestedList);
                        continue;
                    }
                    ArrayList targetList = new ArrayList();
                    for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
                        if (this.excludeKeySet.contains(entry.getKey())) continue;
                        HashMap<String, Object> listItem = new HashMap<String, Object>();
                        listItem.put(this.config.getKeyName(), entry.getKey());
                        listItem.put(this.config.getValueName(), entry.getValue());
                        targetList.add(listItem);
                    }
                    this.removeProcessedFields(sourceMap, recordEvent);
                    recordEvent.put(this.config.getTarget(), targetList);
                }
                catch (Exception e) {
                    LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage("Fail to perform Map to List operation").setCause((Throwable)e).log();
                    recordEvent.getMetadata().addTags(this.config.getTagsOnFailure());
                }
            }
            catch (Exception e) {
                LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage("There was an exception while processing Event [{}]").addArgument((Object)recordEvent).setCause((Throwable)e).log();
                recordEvent.getMetadata().addTags(this.config.getTagsOnFailure());
            }
        }
        return records;
    }

    private Map<String, Object> getSourceMap(Event recordEvent) throws JsonProcessingException {
        Map sourceMap = (Map)recordEvent.get(this.config.getSource(), Map.class);
        return sourceMap;
    }

    private void removeProcessedFields(Map<String, Object> sourceMap, Event recordEvent) {
        if (!this.config.getRemoveProcessedFields()) {
            return;
        }
        if (Objects.equals(this.config.getSource(), "")) {
            for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
                if (this.excludeKeySet.contains(entry.getKey())) continue;
                recordEvent.delete(entry.getKey());
            }
        } else {
            HashMap<String, Object> modifiedSourceMap = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
                if (!this.excludeKeySet.contains(entry.getKey())) continue;
                modifiedSourceMap.put(entry.getKey(), entry.getValue());
            }
            recordEvent.put(this.config.getSource(), modifiedSourceMap);
        }
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }
}

