/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.mutateevent.ListToMapProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="list_to_map", pluginType=Processor.class, pluginConfigurationType=ListToMapProcessorConfig.class)
public class ListToMapProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(ListToMapProcessor.class);
    private final ListToMapProcessorConfig config;
    private final ExpressionEvaluator expressionEvaluator;

    @DataPrepperPluginConstructor
    public ListToMapProcessor(PluginMetrics pluginMetrics, ListToMapProcessorConfig config, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics);
        this.config = config;
        this.expressionEvaluator = expressionEvaluator;
        if (config.getListToMapWhen() != null && !expressionEvaluator.isValidExpressionStatement(config.getListToMapWhen()).booleanValue()) {
            throw new InvalidPluginConfigurationException(String.format("list_to_map_when %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", config.getListToMapWhen()));
        }
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        for (Record<Event> record : records) {
            Event recordEvent = (Event)record.getData();
            try {
                Map<String, Object> targetMap;
                List sourceList;
                if (Objects.nonNull(this.config.getListToMapWhen()) && !this.expressionEvaluator.evaluateConditional(this.config.getListToMapWhen(), recordEvent).booleanValue()) continue;
                try {
                    sourceList = (List)recordEvent.get(this.config.getSource(), List.class);
                }
                catch (Exception e) {
                    LOG.warn(DataPrepperMarkers.EVENT, "Given source path [{}] is not valid on record [{}]", new Object[]{this.config.getSource(), recordEvent, e});
                    recordEvent.getMetadata().addTags(this.config.getTagsOnFailure());
                    continue;
                }
                try {
                    targetMap = this.constructTargetMap(sourceList);
                }
                catch (IllegalArgumentException e) {
                    LOG.warn(DataPrepperMarkers.EVENT, "Cannot find a list at the given source path [{}} on record [{}]", new Object[]{this.config.getSource(), recordEvent, e});
                    recordEvent.getMetadata().addTags(this.config.getTagsOnFailure());
                    continue;
                }
                catch (Exception e) {
                    LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage("Error converting source list to map on record [{}]").addArgument((Object)recordEvent).setCause((Throwable)e).log();
                    recordEvent.getMetadata().addTags(this.config.getTagsOnFailure());
                    continue;
                }
                try {
                    this.updateEvent(recordEvent, targetMap);
                }
                catch (Exception e) {
                    LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage("Error updating record [{}] after converting source list to map").addArgument((Object)recordEvent).setCause((Throwable)e).log();
                    recordEvent.getMetadata().addTags(this.config.getTagsOnFailure());
                }
            }
            catch (Exception e) {
                LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage("There was an exception while processing Event [{}]").addArgument((Object)recordEvent).setCause((Throwable)e).log();
                recordEvent.getMetadata().addTags(this.config.getTagsOnFailure());
            }
        }
        return records;
    }

    private Map<String, Object> constructTargetMap(List<Map<String, Object>> sourceList) {
        HashMap<String, Object> targetMap = new HashMap<String, Object>();
        for (Map<String, Object> itemMap : sourceList) {
            if (this.config.getUseSourceKey()) {
                if (this.config.getFlatten()) {
                    for (String entryKey : itemMap.keySet()) {
                        this.setTargetMapFlattened(targetMap, itemMap, entryKey, entryKey, this.config.getExtractValue());
                    }
                    continue;
                }
                for (String entryKey : itemMap.keySet()) {
                    this.setTargetMapUnflattened(targetMap, itemMap, entryKey, entryKey, this.config.getExtractValue());
                }
                continue;
            }
            String itemKey = (String)itemMap.get(this.config.getKey());
            if (this.config.getFlatten()) {
                this.setTargetMapFlattened(targetMap, itemMap, itemKey, this.config.getValueKey(), this.config.getValueKey() != null);
                continue;
            }
            this.setTargetMapUnflattened(targetMap, itemMap, itemKey, this.config.getValueKey(), this.config.getValueKey() != null);
        }
        return targetMap;
    }

    private void setTargetMapUnflattened(Map<String, Object> targetMap, Map<String, Object> itemMap, String itemKey, String itemValueKey, boolean doExtractValue) {
        if (!targetMap.containsKey(itemKey)) {
            targetMap.put(itemKey, new ArrayList());
        }
        List itemValue = (List)targetMap.get(itemKey);
        if (doExtractValue) {
            itemValue.add(itemMap.get(itemValueKey));
        } else {
            itemValue.add(itemMap);
        }
    }

    private void setTargetMapFlattened(Map<String, Object> targetMap, Map<String, Object> itemMap, String itemKey, String itemValueKey, boolean doExtractValue) {
        if (!targetMap.containsKey(itemKey) || this.config.getFlattenedElement() == ListToMapProcessorConfig.FlattenedElement.LAST) {
            if (doExtractValue) {
                targetMap.put(itemKey, itemMap.get(itemValueKey));
            } else {
                targetMap.put(itemKey, itemMap);
            }
        }
    }

    private void updateEvent(Event recordEvent, Map<String, Object> targetMap) {
        boolean doWriteToRoot = Objects.isNull(this.config.getTarget());
        if (doWriteToRoot) {
            for (Map.Entry<String, Object> entry : targetMap.entrySet()) {
                recordEvent.put(entry.getKey(), entry.getValue());
            }
        } else {
            recordEvent.put(this.config.getTarget(), targetMap);
        }
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }
}

