/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertFalse;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.opensearch.dataprepper.model.annotations.ConditionalRequired;
import org.opensearch.dataprepper.model.annotations.ExampleValues;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.event.EventKeyConfiguration;
import org.opensearch.dataprepper.model.event.EventKeyFactory;

@ConditionalRequired(value={@ConditionalRequired.IfThenElse(ifFulfilled={@ConditionalRequired.SchemaProperty(field="entries", value="null")}, thenExpect={@ConditionalRequired.SchemaProperty(field="with_keys")}), @ConditionalRequired.IfThenElse(ifFulfilled={@ConditionalRequired.SchemaProperty(field="with_keys", value="null")}, thenExpect={@ConditionalRequired.SchemaProperty(field="entries")})})
@JsonPropertyOrder
@JsonClassDescription(value="The <code>delete_entries</code> processor deletes fields from events. You can define the keys you want to delete in the <code>with_keys</code> configuration. Those keys and their values are deleted from events.")
public class DeleteEntryProcessorConfig {
    @JsonProperty(value="with_keys")
    @EventKeyConfiguration(value={EventKeyFactory.EventAction.DELETE})
    @JsonPropertyDescription(value="A list of keys to be deleted. May not be used with entries.")
    private List<@NotNull @NotEmpty EventKey> withKeys;
    @JsonProperty(value="delete_when")
    @JsonPropertyDescription(value="Specifies under what condition the deletion should be performed.")
    private String deleteWhen;
    @Valid
    @JsonProperty(value="entries")
    @JsonPropertyDescription(value="A list of entries to delete from the event.")
    private List<Entry> entries;
    @JsonPropertyDescription(value="Specifies the key of the list of object to iterate over and delete the keys specified in with_keys.")
    @JsonProperty(value="iterate_on")
    private String iterateOn;
    @JsonPropertyDescription(value="Specifies the condition for when to delete the key from each element of a list when using iterate_on.")
    @JsonProperty(value="delete_from_element_when")
    private String deleteFromElementWhen;

    @AssertTrue(message="Either 'entries' or 'with_keys' must be specified, but neither was found")
    @AssertTrue(message="Either 'entries' or 'with_keys' must be specified, but neither was found") boolean isConfigurationPresent() {
        return this.entries != null || this.withKeys != null;
    }

    @AssertFalse(message="Either use 'entries' OR 'with_keys' with 'delete_when' configuration, but not both")
    @AssertFalse(message="Either use 'entries' OR 'with_keys' with 'delete_when' configuration, but not both") boolean hasBothConfigurations() {
        return this.entries != null && this.withKeys != null;
    }

    public List<EventKey> getWithKeys() {
        return this.withKeys;
    }

    public String getDeleteWhen() {
        return this.deleteWhen;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public String getIterateOn() {
        return this.iterateOn;
    }

    public String getDeleteFromElementWhen() {
        return this.deleteFromElementWhen;
    }

    @JsonPropertyOrder
    public static class Entry {
        @NotEmpty
        @NotNull
        @JsonProperty(value="with_keys")
        @EventKeyConfiguration(value={EventKeyFactory.EventAction.DELETE})
        @JsonPropertyDescription(value="A list of keys to be deleted.")
        private @NotEmpty @NotNull List<@NotNull @NotEmpty EventKey> withKeys;
        @JsonProperty(value="delete_when")
        @JsonPropertyDescription(value="Specifies under what condition the deletion should be performed. By default, keys are always deleted. Example: <code>/mykey == \"---\"</code>")
        @ExampleValues(value={@ExampleValues.Example(value="/some_key == null", description="Only runs the deletion if the key some_key is null or does not exist.")})
        private String deleteWhen;
        @JsonPropertyDescription(value="Specifies the condition for when to delete the key from each element of a list when using iterate_on.")
        @JsonProperty(value="delete_from_element_when")
        private String deleteFromElementWhen;
        @JsonPropertyDescription(value="Specifies the key of the list of object to iterate over and delete the keys specified in with_keys.")
        @JsonProperty(value="iterate_on")
        private String iterateOn;

        public List<EventKey> getWithKeys() {
            return this.withKeys;
        }

        public String getDeleteWhen() {
            return this.deleteWhen;
        }

        public String getIterateOn() {
            return this.iterateOn;
        }

        public String getDeleteFromElementWhen() {
            return this.deleteFromElementWhen;
        }

        public Entry(List<EventKey> withKeys, String deleteWhen, String iterateOn, String deleteFromElementWhen) {
            this.withKeys = withKeys;
            this.deleteWhen = deleteWhen;
            this.deleteFromElementWhen = deleteFromElementWhen;
            this.iterateOn = iterateOn;
        }

        public Entry() {
        }
    }
}

