/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperExtensionPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.plugin.ExtensionPlugin;
import org.opensearch.dataprepper.model.plugin.ExtensionPoints;
import org.opensearch.dataprepper.model.plugin.ExtensionProvider;
import org.opensearch.dataprepper.model.plugin.PluginConfigPublisher;
import org.opensearch.dataprepper.model.plugin.PluginConfigValueTranslator;
import org.opensearch.dataprepper.plugins.aws.AwsSecretPluginConfig;
import org.opensearch.dataprepper.plugins.aws.AwsSecretsPluginConfigPublisher;
import org.opensearch.dataprepper.plugins.aws.AwsSecretsPluginConfigPublisherExtensionProvider;
import org.opensearch.dataprepper.plugins.aws.AwsSecretsPluginConfigValueTranslator;
import org.opensearch.dataprepper.plugins.aws.AwsSecretsPluginConfigValueTranslatorExtensionProvider;
import org.opensearch.dataprepper.plugins.aws.AwsSecretsSupplier;
import org.opensearch.dataprepper.plugins.aws.SecretValueDecoder;
import org.opensearch.dataprepper.plugins.aws.SecretsRefreshJob;
import org.opensearch.dataprepper.plugins.aws.SecretsSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperExtensionPlugin(modelType=AwsSecretPluginConfig.class, rootKeyJsonPath="/aws/secrets", allowInPipelineConfigurations=true)
public class AwsSecretPlugin
implements ExtensionPlugin {
    static final int PERIOD_IN_SECONDS = 60;
    private static final Logger LOG = LoggerFactory.getLogger(AwsSecretPlugin.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private ScheduledExecutorService scheduledExecutorService;
    private PluginConfigPublisher pluginConfigPublisher;
    private SecretsSupplier secretsSupplier;
    private PluginMetrics pluginMetrics;
    private final PluginConfigValueTranslator pluginConfigValueTranslator;

    @DataPrepperPluginConstructor
    public AwsSecretPlugin(AwsSecretPluginConfig awsSecretPluginConfig) {
        if (awsSecretPluginConfig != null) {
            SecretValueDecoder secretValueDecoder = new SecretValueDecoder();
            this.secretsSupplier = new AwsSecretsSupplier(secretValueDecoder, awsSecretPluginConfig, OBJECT_MAPPER);
            this.pluginConfigPublisher = new AwsSecretsPluginConfigPublisher();
            this.pluginConfigValueTranslator = new AwsSecretsPluginConfigValueTranslator(this.secretsSupplier);
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            this.pluginMetrics = PluginMetrics.fromNames((String)"secrets", (String)"aws");
            this.submitSecretsRefreshJobs(awsSecretPluginConfig, this.secretsSupplier);
        } else {
            this.pluginConfigValueTranslator = null;
        }
    }

    public void apply(ExtensionPoints extensionPoints) {
        extensionPoints.addExtensionProvider((ExtensionProvider)new AwsSecretsPluginConfigValueTranslatorExtensionProvider(this.pluginConfigValueTranslator));
        extensionPoints.addExtensionProvider((ExtensionProvider)new AwsSecretsPluginConfigPublisherExtensionProvider(this.pluginConfigPublisher));
    }

    private void submitSecretsRefreshJobs(AwsSecretPluginConfig awsSecretPluginConfig, SecretsSupplier secretsSupplier) {
        awsSecretPluginConfig.getAwsSecretManagerConfigurationMap().forEach((key, value) -> {
            if (!value.isDisableRefresh()) {
                SecretsRefreshJob secretsRefreshJob = new SecretsRefreshJob((String)key, secretsSupplier, this.pluginConfigPublisher, this.pluginMetrics);
                long period = value.getRefreshInterval().toSeconds();
                long jitterDelay = ThreadLocalRandom.current().nextLong(60L);
                this.scheduledExecutorService.scheduleAtFixedRate(secretsRefreshJob, period + jitterDelay, period, TimeUnit.SECONDS);
            }
        });
    }

    public void shutdown() {
        if (this.scheduledExecutorService != null) {
            LOG.info("Shutting down secrets refreshing tasks.");
            this.scheduledExecutorService.shutdown();
            try {
                if (!this.scheduledExecutorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    LOG.warn("Secrets refreshing tasks did not terminate in time, forcing termination");
                    this.scheduledExecutorService.shutdownNow();
                }
            }
            catch (InterruptedException ex) {
                LOG.info("Encountered interruption terminating the secrets refreshing tasks execution, attempting to force the termination");
                this.scheduledExecutorService.shutdownNow();
            }
        }
    }
}

