/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.grpc.JsonUnframedGrpcErrorHandler;
import com.linecorp.armeria.server.grpc.TextUnframedGrpcErrorHandler;
import com.linecorp.armeria.server.grpc.UnframedGrpcErrorHandler;
import com.linecorp.armeria.server.grpc.UnframedGrpcStatusMappingFunction;
import io.grpc.Status;
import org.curioswitch.common.protobuf.json.MessageMarshaller;

final class DefaultUnframedGrpcErrorHandler
implements UnframedGrpcErrorHandler {
    private static final JsonUnframedGrpcErrorHandler DEFAULT_JSON_UNFRAMED_GRPC_ERROR_HANDLER = JsonUnframedGrpcErrorHandler.of();
    private static final TextUnframedGrpcErrorHandler DEFAULT_TEXT_UNFRAMED_GRPC_ERROR_HANDLER = TextUnframedGrpcErrorHandler.of();
    private static final DefaultUnframedGrpcErrorHandler DEFAULT = new DefaultUnframedGrpcErrorHandler(DEFAULT_JSON_UNFRAMED_GRPC_ERROR_HANDLER, DEFAULT_TEXT_UNFRAMED_GRPC_ERROR_HANDLER);
    private final JsonUnframedGrpcErrorHandler jsonUnframedGrpcErrorHandler;
    private final TextUnframedGrpcErrorHandler textUnframedGrpcErrorHandler;

    static DefaultUnframedGrpcErrorHandler of() {
        return DEFAULT;
    }

    static DefaultUnframedGrpcErrorHandler of(UnframedGrpcStatusMappingFunction mappingFunction) {
        return DefaultUnframedGrpcErrorHandler.of(mappingFunction, null);
    }

    static DefaultUnframedGrpcErrorHandler of(UnframedGrpcStatusMappingFunction mappingFunction, @Nullable MessageMarshaller jsonMarshaller) {
        JsonUnframedGrpcErrorHandler jsonHandler = jsonMarshaller == null ? JsonUnframedGrpcErrorHandler.of(mappingFunction) : JsonUnframedGrpcErrorHandler.of(mappingFunction, jsonMarshaller);
        TextUnframedGrpcErrorHandler textHandler = TextUnframedGrpcErrorHandler.of(mappingFunction);
        if (jsonHandler == DEFAULT_JSON_UNFRAMED_GRPC_ERROR_HANDLER && textHandler == DEFAULT_TEXT_UNFRAMED_GRPC_ERROR_HANDLER) {
            return DEFAULT;
        }
        return new DefaultUnframedGrpcErrorHandler(jsonHandler, textHandler);
    }

    DefaultUnframedGrpcErrorHandler(JsonUnframedGrpcErrorHandler jsonUnframedGrpcErrorHandler, TextUnframedGrpcErrorHandler textUnframedGrpcErrorHandler) {
        this.jsonUnframedGrpcErrorHandler = jsonUnframedGrpcErrorHandler;
        this.textUnframedGrpcErrorHandler = textUnframedGrpcErrorHandler;
    }

    @Override
    public HttpResponse handle(ServiceRequestContext ctx, Status status, AggregatedHttpResponse response) {
        MediaType grpcMediaType = response.contentType();
        if (grpcMediaType != null && grpcMediaType.isJson()) {
            return this.jsonUnframedGrpcErrorHandler.handle(ctx, status, response);
        }
        return this.textUnframedGrpcErrorHandler.handle(ctx, status, response);
    }
}

