/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.mongo.stream;

import com.mongodb.MongoClientException;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.client.model.changestream.OperationType;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.opensearch.dataprepper.common.concurrent.BackgroundThreadFactory;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.plugins.mongo.buffer.RecordBufferWriter;
import org.opensearch.dataprepper.plugins.mongo.client.BsonHelper;
import org.opensearch.dataprepper.plugins.mongo.client.MongoDBConnection;
import org.opensearch.dataprepper.plugins.mongo.configuration.MongoDBSourceConfig;
import org.opensearch.dataprepper.plugins.mongo.converter.PartitionKeyRecordConverter;
import org.opensearch.dataprepper.plugins.mongo.coordination.partition.StreamPartition;
import org.opensearch.dataprepper.plugins.mongo.coordination.state.StreamProgressState;
import org.opensearch.dataprepper.plugins.mongo.model.S3PartitionStatus;
import org.opensearch.dataprepper.plugins.mongo.model.StreamLoadStatus;
import org.opensearch.dataprepper.plugins.mongo.stream.DataStreamPartitionCheckpoint;
import org.opensearch.dataprepper.plugins.mongo.stream.StreamAcknowledgementManager;
import org.opensearch.dataprepper.plugins.mongo.utils.DocumentDBSourceAggregateMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamWorker {
    public static final String STREAM_PREFIX = "STREAM-";
    private static final Logger LOG = LoggerFactory.getLogger(StreamWorker.class);
    private static final int DEFAULT_EXPORT_COMPLETE_WAIT_INTERVAL_MILLIS = 90000;
    private static final String COLLECTION_SPLITTER = "\\.";
    private static final Set<OperationType> CRUD_OPERATION_TYPE = Set.of(OperationType.INSERT, OperationType.DELETE, OperationType.UPDATE, OperationType.REPLACE);
    private static final Set<OperationType> STREAM_TERMINATE_OPERATION_TYPE = Set.of(OperationType.INVALIDATE, OperationType.DROP, OperationType.DROP_DATABASE);
    static final String SUCCESS_ITEM_COUNTER_NAME = "changeEventsProcessed";
    static final String FAILURE_ITEM_COUNTER_NAME = "changeEventsProcessingErrors";
    static final String BYTES_RECEIVED = "bytesReceived";
    static final String BYTES_PROCESSED = "bytesProcessed";
    private static final long MILLI_SECOND = 1000000L;
    private static final String UPDATE_DESCRIPTION = "updateDescription";
    private static final int BUFFER_WRITE_TIMEOUT_MILLIS = 15000;
    private final RecordBufferWriter recordBufferWriter;
    private final PartitionKeyRecordConverter recordConverter;
    private final DataStreamPartitionCheckpoint partitionCheckpoint;
    private final MongoDBSourceConfig sourceConfig;
    private final Counter successItemsCounter;
    private final Counter failureItemsCounter;
    private final DistributionSummary bytesReceivedSummary;
    private final DistributionSummary bytesProcessedSummary;
    private final StreamAcknowledgementManager streamAcknowledgementManager;
    private final PluginMetrics pluginMetrics;
    private final int recordFlushBatchSize;
    private final int checkPointIntervalInMs;
    private final int bufferWriteIntervalInMs;
    private final int streamBatchSize;
    private final DocumentDBSourceAggregateMetrics documentDBAggregateMetrics;
    private boolean stopWorker = false;
    private final ExecutorService executorService;
    private String lastLocalCheckpoint = null;
    private long lastLocalRecordCount = 0L;
    Optional<S3PartitionStatus> s3PartitionStatus = Optional.empty();
    private Integer currentEpochSecond;
    private int recordsSeenThisSecond = 0;
    final List<Event> records = new ArrayList<Event>();
    final List<Long> recordBytes = new ArrayList<Long>();
    long lastBufferWriteTime = System.currentTimeMillis();
    private String checkPointToken = null;
    private long recordCount = 0L;
    private final Lock lock;

    public static StreamWorker create(RecordBufferWriter recordBufferWriter, PartitionKeyRecordConverter recordConverter, MongoDBSourceConfig sourceConfig, StreamAcknowledgementManager streamAcknowledgementManager, DataStreamPartitionCheckpoint partitionCheckpoint, PluginMetrics pluginMetrics, int recordFlushBatchSize, int checkPointIntervalInMs, int bufferWriteIntervalInMs, int streamBatchSize, DocumentDBSourceAggregateMetrics documentDBAggregateMetrics) {
        return new StreamWorker(recordBufferWriter, recordConverter, sourceConfig, streamAcknowledgementManager, partitionCheckpoint, pluginMetrics, recordFlushBatchSize, checkPointIntervalInMs, bufferWriteIntervalInMs, streamBatchSize, documentDBAggregateMetrics);
    }

    public StreamWorker(RecordBufferWriter recordBufferWriter, PartitionKeyRecordConverter recordConverter, MongoDBSourceConfig sourceConfig, StreamAcknowledgementManager streamAcknowledgementManager, DataStreamPartitionCheckpoint partitionCheckpoint, PluginMetrics pluginMetrics, int recordFlushBatchSize, int checkPointIntervalInMs, int bufferWriteIntervalInMs, int streamBatchSize, DocumentDBSourceAggregateMetrics documentDBAggregateMetrics) {
        this.recordBufferWriter = recordBufferWriter;
        this.recordConverter = recordConverter;
        this.sourceConfig = sourceConfig;
        this.streamAcknowledgementManager = streamAcknowledgementManager;
        this.partitionCheckpoint = partitionCheckpoint;
        this.pluginMetrics = pluginMetrics;
        this.recordFlushBatchSize = recordFlushBatchSize;
        this.checkPointIntervalInMs = checkPointIntervalInMs;
        this.bufferWriteIntervalInMs = bufferWriteIntervalInMs;
        this.streamBatchSize = streamBatchSize;
        this.documentDBAggregateMetrics = documentDBAggregateMetrics;
        this.successItemsCounter = pluginMetrics.counter(SUCCESS_ITEM_COUNTER_NAME);
        this.failureItemsCounter = pluginMetrics.counter(FAILURE_ITEM_COUNTER_NAME);
        this.bytesReceivedSummary = pluginMetrics.summary(BYTES_RECEIVED);
        this.bytesProcessedSummary = pluginMetrics.summary(BYTES_PROCESSED);
        this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)BackgroundThreadFactory.defaultExecutorThreadFactory((String)"mongodb-stream-checkpoint"));
        this.lock = new ReentrantLock();
        if (sourceConfig.isAcknowledgmentsEnabled()) {
            streamAcknowledgementManager.init(Void2 -> this.stop());
        }
        this.executorService.submit(this::bufferWriteAndCheckpointStream);
    }

    private MongoCursor<ChangeStreamDocument<Document>> getChangeStreamCursor(MongoCollection<Document> collection, String resumeToken) {
        ChangeStreamIterable changeStreamIterable = collection.watch(List.of(Aggregates.project((Bson)Projections.exclude((String[])new String[]{UPDATE_DESCRIPTION})))).batchSize(this.streamBatchSize);
        if (resumeToken == null) {
            return changeStreamIterable.fullDocument(FullDocument.UPDATE_LOOKUP).iterator();
        }
        return changeStreamIterable.fullDocument(FullDocument.UPDATE_LOOKUP).resumeAfter(BsonDocument.parse((String)resumeToken)).maxAwaitTime(60L, TimeUnit.SECONDS).iterator();
    }

    private boolean shouldWaitForExport(StreamPartition streamPartition) {
        StreamProgressState progressState = streamPartition.getProgressState().get();
        Optional<StreamLoadStatus> loadStatus = this.partitionCheckpoint.getGlobalStreamLoadStatus();
        return progressState.shouldWaitForExport() && loadStatus.isEmpty();
    }

    private boolean shouldWaitForS3Partition(String collection) {
        this.s3PartitionStatus = this.partitionCheckpoint.getGlobalS3FolderCreationStatus(collection);
        return this.s3PartitionStatus.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStream(StreamPartition streamPartition) {
        this.documentDBAggregateMetrics.getStreamApiInvocations().increment();
        Optional<String> resumeToken = streamPartition.getProgressState().map(StreamProgressState::getResumeToken);
        resumeToken.ifPresent(token -> {
            this.checkPointToken = token;
        });
        Optional<Long> loadedRecords = streamPartition.getProgressState().map(StreamProgressState::getLoadedRecords);
        loadedRecords.ifPresent(count -> {
            this.recordCount = count;
        });
        String collectionDbName = streamPartition.getCollection();
        List<String> collectionDBNameList = List.of(collectionDbName.split(COLLECTION_SPLITTER));
        if (collectionDBNameList.size() < 2) {
            this.documentDBAggregateMetrics.getStream4xxErrors().increment();
            throw new IllegalArgumentException("Invalid Collection Name. Must be in db.collection format");
        }
        try (MongoClient mongoClient = MongoDBConnection.getMongoClient(this.sourceConfig);){
            MongoDatabase database = mongoClient.getDatabase(collectionDBNameList.get(0));
            MongoCollection collection = database.getCollection(collectionDbName.substring(collectionDBNameList.get(0).length() + 1));
            try (MongoCursor<ChangeStreamDocument<Document>> cursor = this.getChangeStreamCursor((MongoCollection<Document>)collection, resumeToken.orElse(null));){
                List<String> s3Partitions;
                while ((this.shouldWaitForExport(streamPartition) || this.shouldWaitForS3Partition(streamPartition.getCollection())) && !Thread.currentThread().isInterrupted()) {
                    LOG.info("Initial load not complete for collection {}, waiting for initial load to be complete before resuming streams.", (Object)collectionDbName);
                    try {
                        Thread.sleep(90000L);
                    }
                    catch (InterruptedException ex) {
                        LOG.info("The StreamScheduler was interrupted while waiting to retry, stopping processing");
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                if ((s3Partitions = this.s3PartitionStatus.get().getPartitions()).isEmpty()) {
                    this.documentDBAggregateMetrics.getStream5xxErrors().increment();
                    throw new IllegalStateException("S3 partitions are not created. Please check the S3 partition creator thread.");
                }
                this.recordConverter.initializePartitions(s3Partitions);
                LOG.info("Starting to watch streams for change events.");
                while (!Thread.currentThread().isInterrupted() && !this.stopWorker) {
                    if (cursor.hasNext()) {
                        try {
                            ChangeStreamDocument document = (ChangeStreamDocument)cursor.next();
                            OperationType operationType = document.getOperationType();
                            LOG.debug("Event Operation type {}", (Object)operationType);
                            if (this.isCRUDOperation(operationType)) {
                                String record = OperationType.DELETE == operationType ? document.getDocumentKey().toJson(BsonHelper.JSON_WRITER_SETTINGS) : ((Document)document.getFullDocument()).toJson(BsonHelper.JSON_WRITER_SETTINGS);
                                long eventCreateTimeEpochMillis = (long)document.getClusterTime().getTime() * 1000L;
                                long eventCreationTimeEpochNanos = this.calculateTieBreakingVersionFromTimestamp(document.getClusterTime().getTime());
                                long bytes = record.getBytes().length;
                                this.bytesReceivedSummary.record((double)bytes);
                                Optional<BsonDocument> primaryKeyDoc = Optional.ofNullable(document.getDocumentKey());
                                String primaryKeyBsonType = primaryKeyDoc.map(bsonDocument -> bsonDocument.get((Object)"_id").getBsonType().name()).orElse("UNKNOWN");
                                Event event = this.recordConverter.convert(record, eventCreateTimeEpochMillis, eventCreationTimeEpochNanos, document.getOperationType(), primaryKeyBsonType);
                                if (this.sourceConfig.getIdKey() != null && !this.sourceConfig.getIdKey().isBlank()) {
                                    event.put(this.sourceConfig.getIdKey(), event.get("_id", Object.class));
                                }
                                event.delete("_id");
                                this.records.add(event);
                                this.recordBytes.add(bytes);
                                this.lock.lock();
                                try {
                                    ++this.recordCount;
                                    this.checkPointToken = document.getResumeToken().toJson(BsonHelper.JSON_WRITER_SETTINGS);
                                    if (this.recordCount % (long)this.recordFlushBatchSize != 0L && System.currentTimeMillis() - this.lastBufferWriteTime < (long)this.bufferWriteIntervalInMs) continue;
                                    this.writeToBuffer();
                                    continue;
                                }
                                finally {
                                    this.lock.unlock();
                                    continue;
                                }
                            }
                            if (this.shouldTerminateChangeStream(operationType)) {
                                this.stop();
                                this.partitionCheckpoint.resetCheckpoint();
                                LOG.warn("The change stream is invalid due to stream operation type {}. Stopping the current change stream. New thread should restart the stream.", (Object)operationType);
                                continue;
                            }
                            LOG.warn("The change stream operation type {} is not handled", (Object)operationType);
                        }
                        catch (Exception e) {
                            LOG.error("Failed to add records to buffer with error", (Throwable)e);
                            this.failureItemsCounter.increment((double)this.records.size());
                        }
                        continue;
                    }
                    LOG.warn("The change stream cursor didn't return any document. Stopping the change stream. New thread should restart the stream.");
                    this.stop();
                    this.partitionCheckpoint.resetCheckpoint();
                }
            }
        }
        catch (MongoClientException | IllegalArgumentException e) {
            this.documentDBAggregateMetrics.getStream4xxErrors().increment();
            LOG.error("Client side exception connecting to cluster and processing stream", e);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            this.documentDBAggregateMetrics.getStream5xxErrors().increment();
            LOG.error("Server side exception connecting to cluster and processing stream", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (!this.records.isEmpty()) {
                LOG.info("Flushing and checkpointing last processed record batch from the stream before terminating");
                this.writeToBuffer(this.records, this.checkPointToken, this.recordCount);
            }
            if (!this.sourceConfig.isAcknowledgmentsEnabled()) {
                this.partitionCheckpoint.checkpoint(this.checkPointToken, this.recordCount);
            }
            System.clearProperty("STOP_S3_SCAN_PROCESSING");
            this.stop();
            this.partitionCheckpoint.giveUpPartition();
            if (this.streamAcknowledgementManager != null) {
                this.streamAcknowledgementManager.shutdown();
            }
        }
    }

    private long calculateTieBreakingVersionFromTimestamp(int eventTimeInEpochSeconds) {
        if (this.currentEpochSecond == null) {
            this.currentEpochSecond = eventTimeInEpochSeconds;
        } else {
            if (this.currentEpochSecond > eventTimeInEpochSeconds) {
                return (long)eventTimeInEpochSeconds * 1000000L;
            }
            if (this.currentEpochSecond < eventTimeInEpochSeconds) {
                this.recordsSeenThisSecond = 0;
                this.currentEpochSecond = eventTimeInEpochSeconds;
            } else {
                ++this.recordsSeenThisSecond;
            }
        }
        return (long)eventTimeInEpochSeconds * 1000000L + (long)this.recordsSeenThisSecond;
    }

    private boolean isCRUDOperation(OperationType operationType) {
        return CRUD_OPERATION_TYPE.contains(operationType);
    }

    private boolean shouldTerminateChangeStream(OperationType operationType) {
        return STREAM_TERMINATE_OPERATION_TYPE.contains(operationType);
    }

    private void writeToBuffer(List<Event> records, String checkPointToken, long recordCount) {
        AcknowledgementSet acknowledgementSet = this.streamAcknowledgementManager.createAcknowledgementSet(checkPointToken, recordCount).orElse(null);
        this.recordBufferWriter.writeToBuffer(acknowledgementSet, records);
        this.successItemsCounter.increment((double)records.size());
        if (acknowledgementSet != null) {
            acknowledgementSet.complete();
        }
    }

    private void writeToBuffer() {
        LOG.debug("Write to buffer for line {} to {}", (Object)this.lastLocalRecordCount, (Object)this.recordCount);
        this.writeToBuffer(this.records, this.checkPointToken, this.recordCount);
        this.lastLocalCheckpoint = this.checkPointToken;
        this.lastLocalRecordCount = this.recordCount;
        this.lastBufferWriteTime = System.currentTimeMillis();
        this.bytesProcessedSummary.record((double)this.recordBytes.stream().mapToLong(Long::longValue).sum());
        this.records.clear();
        this.recordBytes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bufferWriteAndCheckpointStream() {
        long lastCheckpointTime = System.currentTimeMillis();
        while (!Thread.currentThread().isInterrupted() && !this.stopWorker) {
            if (!this.records.isEmpty() && this.lastBufferWriteTime < Instant.now().minusMillis(15000L).toEpochMilli()) {
                this.lock.lock();
                LOG.debug("Writing to buffer due to buffer write delay");
                try {
                    this.writeToBuffer();
                }
                catch (Exception e) {
                    LOG.error("Failed to add records to buffer with error", (Throwable)e);
                    this.failureItemsCounter.increment((double)this.records.size());
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (!this.sourceConfig.isAcknowledgmentsEnabled() && System.currentTimeMillis() - lastCheckpointTime >= (long)this.checkPointIntervalInMs) {
                try {
                    this.lock.lock();
                    LOG.debug("Perform regular checkpoint for resume token {} at record count {}", (Object)this.lastLocalCheckpoint, (Object)this.lastLocalRecordCount);
                    this.partitionCheckpoint.checkpoint(this.lastLocalCheckpoint, this.lastLocalRecordCount);
                }
                catch (Exception e) {
                    LOG.warn("Exception checkpointing the current state. The stream record processing will start from previous checkpoint.", (Throwable)e);
                    this.stop();
                }
                finally {
                    this.lock.unlock();
                }
                lastCheckpointTime = System.currentTimeMillis();
            }
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
                break;
            }
        }
        LOG.info("Checkpoint monitoring thread interrupted.");
    }

    void stop() {
        this.stopWorker = true;
    }
}

