/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.mongo.export;

import java.time.Duration;
import java.util.Optional;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.mongo.coordination.partition.DataQueryPartition;
import org.opensearch.dataprepper.plugins.mongo.coordination.state.DataQueryProgressState;
import org.opensearch.dataprepper.plugins.mongo.s3partition.S3FolderPartitionCoordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataQueryPartitionCheckpoint
extends S3FolderPartitionCoordinator {
    private static final Logger LOG = LoggerFactory.getLogger(DataQueryPartitionCheckpoint.class);
    static final Duration CHECKPOINT_OWNERSHIP_TIMEOUT_INCREASE = Duration.ofMinutes(5L);
    private final EnhancedSourceCoordinator enhancedSourceCoordinator;
    private final DataQueryPartition dataQueryPartition;

    public DataQueryPartitionCheckpoint(EnhancedSourceCoordinator enhancedSourceCoordinator, DataQueryPartition dataQueryPartition) {
        super(enhancedSourceCoordinator);
        this.enhancedSourceCoordinator = enhancedSourceCoordinator;
        this.dataQueryPartition = dataQueryPartition;
    }

    private void setProgressState(long records) {
        Optional<DataQueryProgressState> progressState = this.dataQueryPartition.getProgressState();
        progressState.get().setLoadedRecords(records);
    }

    public void checkpoint(int recordNumber) {
        LOG.debug("Checkpoint partition query " + this.dataQueryPartition.getQuery() + " with record number " + recordNumber);
        this.setProgressState(recordNumber);
        this.enhancedSourceCoordinator.saveProgressStateForPartition((EnhancedSourcePartition)this.dataQueryPartition, CHECKPOINT_OWNERSHIP_TIMEOUT_INCREASE);
    }

    public void updateDatafileForAcknowledgmentWait(Duration acknowledgmentSetTimeout) {
        this.enhancedSourceCoordinator.saveProgressStateForPartition((EnhancedSourcePartition)this.dataQueryPartition, acknowledgmentSetTimeout);
    }
}

