/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.mongo.client;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.io.File;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import org.opensearch.dataprepper.plugins.mongo.configuration.MongoDBSourceConfig;
import org.opensearch.dataprepper.plugins.truststore.TrustStoreProvider;

public class MongoDBConnection {
    private static final String MONGO_CONNECTION_STRING_TEMPLATE = "mongodb://%s:%s@%s:%s/?replicaSet=rs0&readpreference=%s&ssl=%s&tlsAllowInvalidHostnames=%s&directConnection=%s";

    public static MongoClient getMongoClient(MongoDBSourceConfig sourceConfig) {
        String connectionString = MongoDBConnection.getConnectionString(sourceConfig);
        MongoClientSettings.Builder settingBuilder = MongoClientSettings.builder().applyConnectionString(new ConnectionString(connectionString));
        if (Objects.nonNull(sourceConfig.getTrustStoreFilePath())) {
            File truststoreFilePath = new File(sourceConfig.getTrustStoreFilePath());
            settingBuilder.applyToSslSettings(builder -> {
                builder.enabled(sourceConfig.getTls().booleanValue());
                builder.invalidHostNameAllowed(sourceConfig.getSslInsecureDisableVerification().booleanValue());
                builder.context(TrustStoreProvider.createSSLContext((Path)truststoreFilePath.toPath(), (String)sourceConfig.getTrustStorePassword()));
            });
        }
        return MongoClients.create((MongoClientSettings)settingBuilder.build());
    }

    private static String encodeString(String input) {
        return URLEncoder.encode(input, StandardCharsets.UTF_8);
    }

    private static String getConnectionString(MongoDBSourceConfig sourceConfig) {
        String password;
        String username;
        try {
            username = MongoDBConnection.encodeString(sourceConfig.getAuthenticationConfig().getUsername());
        }
        catch (Exception e) {
            throw new RuntimeException("Unsupported characters in username.");
        }
        try {
            password = MongoDBConnection.encodeString(sourceConfig.getAuthenticationConfig().getPassword());
        }
        catch (Exception e) {
            throw new RuntimeException("Unsupported characters in password.");
        }
        if (sourceConfig.getHost() == null || sourceConfig.getHost().isBlank()) {
            throw new RuntimeException("The host should not be null or empty.");
        }
        String hostname = sourceConfig.getHost();
        int port = sourceConfig.getPort();
        String tls = sourceConfig.getTls().toString();
        String invalidHostAllowed = sourceConfig.getSslInsecureDisableVerification().toString();
        String readPreference = sourceConfig.getReadPreference();
        String directionConnection = sourceConfig.getDirectConnection().toString();
        return String.format(MONGO_CONNECTION_STRING_TEMPLATE, username, password, hostname, port, readPreference, tls, invalidHostAllowed, directionConnection);
    }
}

