/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.state.preprocessor;

import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.ImputationMethod;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.preprocessor.Preprocessor;
import com.amazon.randomcutforest.parkservices.state.preprocessor.PreprocessorState;
import com.amazon.randomcutforest.parkservices.state.statistics.DeviationMapper;
import com.amazon.randomcutforest.parkservices.statistics.Deviation;
import com.amazon.randomcutforest.state.IStateMapper;

public class PreprocessorMapper
implements IStateMapper<Preprocessor, PreprocessorState> {
    public Preprocessor toModel(PreprocessorState state, long seed) {
        DeviationMapper deviationMapper = new DeviationMapper();
        Deviation[] deviations = DeviationMapper.getDeviations(state.getDeviationStates(), deviationMapper);
        Deviation[] timeStampDeviations = DeviationMapper.getDeviations(state.getTimeStampDeviationStates(), deviationMapper);
        Deviation[] dataQuality = DeviationMapper.getDeviations(state.getDataQualityStates(), deviationMapper);
        Object preprocessorBuilder = ((Preprocessor.Builder)((Preprocessor.Builder)((Preprocessor.Builder)((Preprocessor.Builder)((Preprocessor.Builder)((Preprocessor.Builder)((Preprocessor.Builder)((Preprocessor.Builder)((Preprocessor.Builder)((Preprocessor.Builder)((Preprocessor.Builder)((Preprocessor.Builder)((Preprocessor.Builder)((Preprocessor.Builder)new Preprocessor.Builder().forestMode(ForestMode.valueOf((String)state.getForestMode()))).shingleSize(state.getShingleSize())).dimensions(state.getDimensions())).normalizeTime(state.isNormalizeTime())).imputationMethod(ImputationMethod.valueOf((String)state.getImputationMethod()))).fillValues(state.getDefaultFill())).inputLength(state.getInputLength())).weights(state.getWeights())).transformMethod(TransformMethod.valueOf((String)state.getTransformMethod()))).startNormalization(state.getStartNormalization())).useImputedFraction(state.getUseImputedFraction())).timeDeviations(timeStampDeviations)).deviations(deviations)).dataQuality(dataQuality)).timeDecay(state.getTimeDecay());
        Preprocessor preprocessor = ((Preprocessor.Builder)preprocessorBuilder).build();
        preprocessor.setInitialValues(state.getInitialValues());
        preprocessor.setInitialTimeStamps(state.getInitialTimeStamps());
        preprocessor.setClipFactor(state.getClipFactor());
        preprocessor.setValuesSeen(state.getValuesSeen());
        preprocessor.setInternalTimeStamp(state.getInternalTimeStamp());
        preprocessor.setLastShingledInput(state.getLastShingledInput());
        preprocessor.setLastShingledPoint(state.getLastShingledPoint());
        preprocessor.setPreviousTimeStamps(state.getPreviousTimeStamps());
        preprocessor.setNormalizeTime(state.isNormalizeTime());
        return preprocessor;
    }

    public PreprocessorState toState(Preprocessor model) {
        PreprocessorState state = new PreprocessorState();
        state.setShingleSize(model.getShingleSize());
        state.setDimensions(model.getDimension());
        state.setInputLength(model.getInputLength());
        state.setClipFactor(model.getClipFactor());
        state.setDefaultFill(model.getDefaultFill());
        state.setImputationMethod(model.getImputationMethod().name());
        state.setTransformMethod(model.getTransformMethod().name());
        state.setWeights(model.getWeights());
        state.setForestMode(model.getMode().name());
        state.setInitialTimeStamps(model.getInitialTimeStamps());
        state.setInitialValues(model.getInitialValues());
        state.setUseImputedFraction(model.getUseImputedFraction());
        state.setNormalizeTime(model.isNormalizeTime());
        state.setStartNormalization(model.getStartNormalization());
        state.setStopNormalization(model.getStopNormalization());
        state.setPreviousTimeStamps(model.getPreviousTimeStamps());
        state.setLastShingledInput(model.getLastShingledInput());
        state.setLastShingledPoint(model.getLastShingledPoint());
        state.setValuesSeen(model.getValuesSeen());
        state.setInternalTimeStamp(model.getInternalTimeStamp());
        DeviationMapper deviationMapper = new DeviationMapper();
        state.setTimeDecay(model.getTimeDecay());
        state.setDeviationStates(DeviationMapper.getStates(model.getDeviationList(), deviationMapper));
        state.setTimeStampDeviationStates(DeviationMapper.getStates(model.getTimeStampDeviations(), deviationMapper));
        state.setDataQualityStates(DeviationMapper.getStates(model.getDataQuality(), deviationMapper));
        return state;
    }
}

