/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.loghttp;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Blocking;
import com.linecorp.armeria.server.annotation.Post;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.http.codec.JsonCodec;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.codec.InputCodec;
import org.opensearch.dataprepper.model.log.JacksonLog;
import org.opensearch.dataprepper.model.log.Log;
import org.opensearch.dataprepper.model.record.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Blocking
public class LogHTTPService {
    private static final int SERIALIZATION_OVERHEAD = 1024;
    public static final String REQUESTS_RECEIVED = "requestsReceived";
    public static final String SUCCESS_REQUESTS = "successRequests";
    public static final String REQUESTS_OVER_OPTIMAL_SIZE = "requestsOverOptimalSize";
    public static final String REQUESTS_OVER_MAXIMUM_SIZE = "requestsOverMaximumSize";
    public static final String PAYLOAD_SIZE = "payloadSize";
    public static final String REQUEST_PROCESS_DURATION = "requestProcessDuration";
    private static final Logger LOG = LoggerFactory.getLogger(LogHTTPService.class);
    private final JsonCodec jsonCodec = new JsonCodec();
    private final Buffer<Record<Log>> buffer;
    private final InputCodec codec;
    private final int bufferWriteTimeoutInMillis;
    private final Counter requestsReceivedCounter;
    private final Counter successRequestsCounter;
    private final Counter requestsOverOptimalSizeCounter;
    private final Counter requestsOverMaximumSizeCounter;
    private final DistributionSummary payloadSizeSummary;
    private final Timer requestProcessDuration;
    private Integer bufferMaxRequestLength;
    private Integer bufferOptimalRequestLength;

    public LogHTTPService(int bufferWriteTimeoutInMillis, Buffer<Record<Log>> buffer, PluginMetrics pluginMetrics, InputCodec codec) {
        this.buffer = buffer;
        this.bufferWriteTimeoutInMillis = bufferWriteTimeoutInMillis;
        this.bufferMaxRequestLength = buffer.getMaxRequestSize().isPresent() ? (Integer)buffer.getMaxRequestSize().get() : null;
        this.bufferOptimalRequestLength = buffer.getOptimalRequestSize().isPresent() ? (Integer)buffer.getOptimalRequestSize().get() : null;
        this.codec = codec;
        this.requestsReceivedCounter = pluginMetrics.counter(REQUESTS_RECEIVED);
        this.successRequestsCounter = pluginMetrics.counter(SUCCESS_REQUESTS);
        this.requestsOverOptimalSizeCounter = pluginMetrics.counter(REQUESTS_OVER_OPTIMAL_SIZE);
        this.requestsOverMaximumSizeCounter = pluginMetrics.counter(REQUESTS_OVER_MAXIMUM_SIZE);
        this.payloadSizeSummary = pluginMetrics.summary(PAYLOAD_SIZE);
        this.requestProcessDuration = pluginMetrics.timer(REQUEST_PROCESS_DURATION);
    }

    @Post
    public HttpResponse doPost(ServiceRequestContext serviceRequestContext, AggregatedHttpRequest aggregatedHttpRequest) throws Exception {
        this.requestsReceivedCounter.increment();
        this.payloadSizeSummary.record((double)aggregatedHttpRequest.content().length());
        if (serviceRequestContext.isTimedOut()) {
            return HttpResponse.of((HttpStatus)HttpStatus.REQUEST_TIMEOUT);
        }
        return (HttpResponse)this.requestProcessDuration.recordCallable(() -> this.processRequest(aggregatedHttpRequest));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    HttpResponse processRequest(AggregatedHttpRequest aggregatedHttpRequest) throws Exception {
        block14: {
            List jsonList;
            HttpData content;
            block13: {
                content = aggregatedHttpRequest.content();
                if (!this.buffer.isByteBuffer()) break block13;
                if (this.bufferMaxRequestLength != null && this.bufferOptimalRequestLength != null && content.array().length > this.bufferOptimalRequestLength) {
                    this.jsonCodec.serializeSplit(content, this::writeChunkedBody, this.bufferOptimalRequestLength - 1024);
                    break block14;
                } else {
                    try {
                        this.jsonCodec.validate(content);
                    }
                    catch (IOException e) {
                        LOG.error("Failed to parse the request of size {} due to: {}", (Object)content.length(), (Object)e.getMessage());
                        throw new IOException("Bad request data format. Needs to be json array.", e.getCause());
                    }
                    try {
                        this.buffer.writeBytes(content.array(), null, this.bufferWriteTimeoutInMillis);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to write the request of size {} due to: {}", (Object)content.length(), (Object)e.getMessage());
                        throw e;
                    }
                }
            }
            ArrayList records = new ArrayList();
            if (this.codec != null) {
                try {
                    this.codec.parse(content.toInputStream(), record -> records.add(new Record((Object)((Log)record.getData()))));
                }
                catch (IOException e) {
                    LOG.error("Failed to parse the request of size {} using specified input codec {} due to: {}", new Object[]{content.length(), this.codec.getClass(), e.getMessage()});
                    throw new IOException("Bad request data format. ", e.getCause());
                }
            }
            try {
                jsonList = this.jsonCodec.parse(content);
            }
            catch (IOException e) {
                LOG.error("Failed to parse the request of size {} due to: {}", (Object)content.length(), (Object)e.getMessage());
                throw new IOException("Bad request data format. Needs to be json array.", e.getCause());
            }
            records.addAll(jsonList.stream().map(this::buildRecordLog).collect(Collectors.toList()));
            try {
                this.buffer.writeAll(records, this.bufferWriteTimeoutInMillis);
            }
            catch (Exception e) {
                LOG.error("Failed to write the request of size {} due to: {}", (Object)content.length(), (Object)e.getMessage());
                throw e;
            }
        }
        this.successRequestsCounter.increment();
        return HttpResponse.of((HttpStatus)HttpStatus.OK);
    }

    private void writeChunkedBody(String chunk) {
        byte[] chunkBytes = chunk.getBytes();
        if (chunkBytes.length > this.bufferMaxRequestLength) {
            this.requestsOverMaximumSizeCounter.increment();
            LOG.error("Unable to write chunked bytes of size {} as it exceeds the maximum buffer size of {}", (Object)chunkBytes.length, (Object)this.bufferMaxRequestLength);
            return;
        }
        if (chunkBytes.length > this.bufferOptimalRequestLength) {
            this.requestsOverOptimalSizeCounter.increment();
        }
        String key = UUID.randomUUID().toString();
        try {
            this.buffer.writeBytes(chunkBytes, key, this.bufferWriteTimeoutInMillis);
        }
        catch (Exception e) {
            LOG.error("Failed to write chunked bytes of size {} due to: {}", (Object)chunkBytes.length, (Object)e.getMessage());
        }
    }

    private Record<Log> buildRecordLog(String json) {
        JacksonLog log = ((JacksonLog.Builder)JacksonLog.builder().withData((Object)json).getThis()).build();
        return new Record((Object)log);
    }
}

