/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearchapi;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Blocking;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Post;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.dataprepper.http.BaseHttpService;
import org.opensearch.dataprepper.http.codec.MultiLineJsonCodec;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventType;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.opensearch.OpenSearchBulkActions;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.source.opensearchapi.model.BulkAPIRequestParams;
import org.opensearch.dataprepper.plugins.source.opensearchapi.model.BulkActionAndMetadataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Blocking
public class OpenSearchAPIService
implements BaseHttpService {
    public static final String REQUESTS_RECEIVED = "RequestsReceived";
    public static final String SUCCESS_REQUESTS = "SuccessRequests";
    public static final String PAYLOAD_SIZE = "PayloadSize";
    public static final String REQUEST_PROCESS_DURATION = "requestProcessDuration";
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchAPIService.class);
    private final MultiLineJsonCodec jsonCodec = new MultiLineJsonCodec();
    private final Buffer<Record<Event>> buffer;
    private final int bufferWriteTimeoutInMillis;
    private final Counter requestsReceivedCounter;
    private final Counter successRequestsCounter;
    private final DistributionSummary payloadSizeSummary;
    private final Timer requestProcessDuration;

    public OpenSearchAPIService(int bufferWriteTimeoutInMillis, Buffer<Record<Event>> buffer, PluginMetrics pluginMetrics) {
        this.buffer = buffer;
        this.bufferWriteTimeoutInMillis = bufferWriteTimeoutInMillis;
        this.requestsReceivedCounter = pluginMetrics.counter(REQUESTS_RECEIVED);
        this.successRequestsCounter = pluginMetrics.counter(SUCCESS_REQUESTS);
        this.payloadSizeSummary = pluginMetrics.summary(PAYLOAD_SIZE);
        this.requestProcessDuration = pluginMetrics.timer(REQUEST_PROCESS_DURATION);
    }

    @Post(value="/_bulk")
    public HttpResponse doPostBulk(ServiceRequestContext serviceRequestContext, AggregatedHttpRequest aggregatedHttpRequest, @Param(value="pipeline") @Nullable String pipeline, @Param(value="routing") @Nullable String routing) throws Exception {
        BulkAPIRequestParams bulkAPIRequestParams = BulkAPIRequestParams.builder().pipeline(pipeline).routing(routing).build();
        return (HttpResponse)this.requestProcessDuration.recordCallable(() -> this.processBulkRequest(serviceRequestContext, aggregatedHttpRequest, bulkAPIRequestParams));
    }

    @Post(value="/{index}/_bulk")
    public HttpResponse doPostBulkIndex(ServiceRequestContext serviceRequestContext, AggregatedHttpRequest aggregatedHttpRequest, @Param(value="index") String index, @Param(value="pipeline") @Nullable String pipeline, @Param(value="routing") @Nullable String routing) throws Exception {
        BulkAPIRequestParams bulkAPIRequestParams = BulkAPIRequestParams.builder().index(index).pipeline(pipeline).routing(routing).build();
        return (HttpResponse)this.requestProcessDuration.recordCallable(() -> this.processBulkRequest(serviceRequestContext, aggregatedHttpRequest, bulkAPIRequestParams));
    }

    private HttpResponse processBulkRequest(ServiceRequestContext serviceRequestContext, AggregatedHttpRequest aggregatedHttpRequest, BulkAPIRequestParams bulkAPIRequestParams) throws Exception {
        List bulkRequestPayloadList;
        this.requestsReceivedCounter.increment();
        this.payloadSizeSummary.record((double)aggregatedHttpRequest.content().length());
        if (serviceRequestContext.isTimedOut()) {
            return HttpResponse.of((HttpStatus)HttpStatus.REQUEST_TIMEOUT);
        }
        HttpData content = aggregatedHttpRequest.content();
        try {
            bulkRequestPayloadList = this.jsonCodec.parse(content);
        }
        catch (IOException e) {
            LOG.error("Failed to parse the request of size {} due to: {}", (Object)content.length(), (Object)e.getMessage());
            throw new IOException("Bad request data format.", e.getCause());
        }
        try {
            if (this.buffer.isByteBuffer()) {
                this.buffer.writeBytes(content.array(), null, this.bufferWriteTimeoutInMillis);
            } else {
                List<Record<Event>> records = this.generateEventsFromBulkRequest(bulkRequestPayloadList, bulkAPIRequestParams);
                this.buffer.writeAll(records, this.bufferWriteTimeoutInMillis);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to write the request of size {} due to: {}", (Object)content.length(), (Object)e.getMessage());
            throw e;
        }
        this.successRequestsCounter.increment();
        return HttpResponse.of((HttpStatus)HttpStatus.OK);
    }

    private boolean isValidBulkAction(Map<String, Object> actionMap) {
        return Arrays.stream(OpenSearchBulkActions.values()).anyMatch(bulkAction -> actionMap.containsKey(bulkAction.toString()));
    }

    private List<Record<Event>> generateEventsFromBulkRequest(List<Map<String, Object>> bulkRequestPayloadList, BulkAPIRequestParams bulkAPIRequestParams) throws Exception {
        ArrayList<Record<Event>> records = new ArrayList<Record<Event>>();
        Iterator<Map<String, Object>> bulkRequestPayloadListIterator = bulkRequestPayloadList.iterator();
        while (bulkRequestPayloadListIterator.hasNext()) {
            Map<String, Object> actionMetadataRow = bulkRequestPayloadListIterator.next();
            if (!this.isValidBulkAction(actionMetadataRow)) {
                throw new IOException("Invalid request data.");
            }
            BulkActionAndMetadataObject bulkActionAndMetadataObject = new BulkActionAndMetadataObject(actionMetadataRow);
            boolean isDeleteAction = bulkActionAndMetadataObject.getAction().equals(OpenSearchBulkActions.DELETE.toString());
            Map<String, Object> documentDataObject = null;
            if (!isDeleteAction) {
                if (!bulkRequestPayloadListIterator.hasNext()) {
                    throw new IOException("Invalid request data.");
                }
                documentDataObject = bulkRequestPayloadListIterator.next();
                if (this.isValidBulkAction(documentDataObject)) {
                    throw new IOException("Invalid request data.");
                }
            }
            JacksonEvent event = this.createBulkRequestActionEvent(bulkActionAndMetadataObject, bulkAPIRequestParams, documentDataObject);
            records.add((Record<Event>)new Record((Object)event));
        }
        return records;
    }

    private JacksonEvent createBulkRequestActionEvent(BulkActionAndMetadataObject bulkActionAndMetadataObject, BulkAPIRequestParams bulkAPIRequestParams, Map<String, Object> optionalDocumentData) {
        String routing;
        String pipeline;
        JacksonEvent.Builder eventBuilder = JacksonEvent.builder().withEventType(EventType.DOCUMENT.toString());
        if (optionalDocumentData != null) {
            eventBuilder.withData(optionalDocumentData);
        }
        JacksonEvent event = eventBuilder.build();
        String index = !StringUtils.isEmpty((CharSequence)bulkAPIRequestParams.getIndex()) ? bulkAPIRequestParams.getIndex() : bulkActionAndMetadataObject.getIndex();
        event.getMetadata().setAttribute("opensearch_action", (Object)bulkActionAndMetadataObject.getAction());
        event.getMetadata().setAttribute("opensearch_index", (Object)index);
        String docId = bulkActionAndMetadataObject.getDocId();
        if (!StringUtils.isBlank((CharSequence)docId) && !StringUtils.isEmpty((CharSequence)docId)) {
            event.getMetadata().setAttribute("opensearch_id", (Object)docId);
        }
        if (!StringUtils.isBlank((CharSequence)(pipeline = bulkAPIRequestParams.getPipeline())) && !StringUtils.isEmpty((CharSequence)pipeline)) {
            event.getMetadata().setAttribute("opensearch_pipeline", (Object)pipeline);
        }
        if (!StringUtils.isBlank((CharSequence)(routing = bulkAPIRequestParams.getRouting())) && !StringUtils.isEmpty((CharSequence)routing)) {
            event.getMetadata().setAttribute("opensearch_routing", (Object)routing);
        }
        return event;
    }
}

