/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline.router;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.model.configuration.ConditionalRoute;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RouteEventEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RouteEventEvaluator.class);
    private final ExpressionEvaluator evaluator;
    private final Collection<ConditionalRoute> routes;

    RouteEventEvaluator(ExpressionEvaluator evaluator, Collection<ConditionalRoute> routes) {
        this.evaluator = evaluator;
        this.routes = routes;
    }

    Map<Record, Set<String>> evaluateEventRoutes(Collection<Record> records) {
        HashMap<Record, Set<String>> recordsToRoutes = new HashMap<Record, Set<String>>();
        int nonEventRecords = 0;
        for (Record record : records) {
            Object data = record.getData();
            if (data instanceof Event) {
                Event event = (Event)data;
                Set<String> matchedRoutes = this.findMatchedRoutes(event);
                recordsToRoutes.put(record, matchedRoutes);
                continue;
            }
            ++nonEventRecords;
            recordsToRoutes.put(record, Collections.emptySet());
        }
        if (nonEventRecords > 0) {
            LOG.warn("Received {} records which are not events. These will have no routes applied.", (Object)nonEventRecords);
        }
        return recordsToRoutes;
    }

    private Set<String> findMatchedRoutes(Event event) {
        HashSet<String> matchRoutes = new HashSet<String>();
        for (ConditionalRoute route : this.routes) {
            try {
                if (!this.evaluator.evaluateConditional(route.getCondition(), event).booleanValue()) continue;
                matchRoutes.add(route.getName());
            }
            catch (Exception ex) {
                LOG.error("Failed to evaluate route. This route will not be applied to any events.", (Throwable)ex);
            }
        }
        return matchRoutes;
    }
}

