/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.dataprepper.DataPrepperShutdownOptions;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PipelineShutdown {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineShutdown.class);
    private final AtomicBoolean stopRequested = new AtomicBoolean(false);
    private final Duration pipelineConfiguredBufferDrainTimeout;
    private final Clock clock;
    private final String pipelineName;
    private Instant shutdownRequestedAt;
    private Instant forceStopReadingBuffersAt;
    private Duration bufferDrainTimeoutOverride;
    private Duration bufferDrainTimeout;

    PipelineShutdown(String pipelineName, Buffer<?> buffer) {
        this(pipelineName, buffer, Clock.systemDefaultZone());
    }

    PipelineShutdown(String pipelineName, Buffer<?> buffer, Clock clock) {
        this.pipelineName = pipelineName;
        this.bufferDrainTimeout = this.pipelineConfiguredBufferDrainTimeout = Objects.requireNonNull(buffer.getDrainTimeout());
        this.clock = clock;
    }

    public void shutdown(DataPrepperShutdownOptions dataPrepperShutdownOptions) {
        Duration bufferDrainTimeoutOverride;
        boolean stopPreviouslyRequested = this.stopRequested.get();
        if (stopPreviouslyRequested) {
            return;
        }
        this.stopRequested.set(true);
        this.shutdownRequestedAt = this.now();
        Duration bufferReadTimeout = dataPrepperShutdownOptions.getBufferReadTimeout();
        if (bufferReadTimeout != null) {
            this.forceStopReadingBuffersAt = this.shutdownRequestedAt.plus(bufferReadTimeout);
        }
        if ((bufferDrainTimeoutOverride = dataPrepperShutdownOptions.getBufferDrainTimeout()) != null) {
            this.bufferDrainTimeoutOverride = bufferDrainTimeoutOverride;
            this.bufferDrainTimeout = bufferDrainTimeoutOverride;
        }
        LOG.info("Started shutdown for pipeline {}. Requested at {}. Force stop reading buffers at {}. The buffer drain timeout to use is {}", new Object[]{this.pipelineName, this.shutdownRequestedAt, this.forceStopReadingBuffersAt, this.bufferDrainTimeout});
    }

    boolean isStopRequested() {
        return this.stopRequested.get();
    }

    boolean isForceStopReadingBuffers() {
        return this.forceStopReadingBuffersAt != null && this.now().isAfter(this.forceStopReadingBuffersAt);
    }

    public Duration getBufferDrainTimeout() {
        return this.bufferDrainTimeout;
    }

    private Instant now() {
        return Instant.ofEpochMilli(this.clock.millis());
    }
}

