/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder.server;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import io.micrometer.core.instrument.Counter;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.buffer.SizeOverflowException;

public class ResponseHandler {
    static final String REQUESTS_TOO_LARGE = "requestsTooLarge";
    static final String REQUEST_TIMEOUTS = "requestTimeouts";
    static final String REQUESTS_UNPROCESSABLE = "requestsUnprocessable";
    static final String BAD_REQUESTS = "badRequests";
    private final Counter requestsTooLargeCounter;
    private final Counter requestTimeoutsCounter;
    private final Counter requestsUnprocessableCounter;
    private final Counter badRequestsCounter;

    public ResponseHandler(PluginMetrics pluginMetrics) {
        this.requestsTooLargeCounter = pluginMetrics.counter(REQUESTS_TOO_LARGE);
        this.requestTimeoutsCounter = pluginMetrics.counter(REQUEST_TIMEOUTS);
        this.requestsUnprocessableCounter = pluginMetrics.counter(REQUESTS_UNPROCESSABLE);
        this.badRequestsCounter = pluginMetrics.counter(BAD_REQUESTS);
    }

    public HttpResponse handleException(Exception e, String message) {
        Objects.requireNonNull(message);
        if (e instanceof SizeOverflowException) {
            this.requestsTooLargeCounter.increment();
            return HttpResponse.of((HttpStatus)HttpStatus.REQUEST_ENTITY_TOO_LARGE, (MediaType)MediaType.ANY_TYPE, (String)message);
        }
        if (e instanceof TimeoutException) {
            this.requestTimeoutsCounter.increment();
            return HttpResponse.of((HttpStatus)HttpStatus.REQUEST_TIMEOUT, (MediaType)MediaType.ANY_TYPE, (String)message);
        }
        if (e instanceof NullPointerException) {
            this.requestsUnprocessableCounter.increment();
            return HttpResponse.of((HttpStatus)HttpStatus.UNPROCESSABLE_ENTITY, (MediaType)MediaType.ANY_TYPE, (String)message);
        }
        this.badRequestsCounter.increment();
        return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.ANY_TYPE, (String)message);
    }
}

