/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder.codec;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.ObjectInputFilter;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderConfiguration;
import org.opensearch.dataprepper.core.peerforwarder.codec.JacksonPeerForwarderCodec;
import org.opensearch.dataprepper.core.peerforwarder.codec.JavaPeerForwarderCodec;
import org.opensearch.dataprepper.core.peerforwarder.codec.LoggingObjectInputFilter;
import org.opensearch.dataprepper.core.peerforwarder.codec.PeerForwarderCodec;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.yaml.snakeyaml.LoaderOptions;

@Configuration
public class PeerForwarderCodecAppConfig {
    @Bean
    public PeerForwarderCodec peerForwarderCodec(PeerForwarderConfiguration peerForwarderConfiguration, ObjectInputFilter objectInputFilter, @Qualifier(value="peerForwarderObjectMapper") ObjectMapper objectMapper) {
        return peerForwarderConfiguration.getBinaryCodec() ? new JavaPeerForwarderCodec(objectInputFilter) : new JacksonPeerForwarderCodec(objectMapper);
    }

    @Bean(name={"peerForwarderObjectMapper"})
    public ObjectMapper objectMapper() {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(0xA00000);
        YAMLFactory yamlFactory = YAMLFactory.builder().loaderOptions(loaderOptions).build();
        return new ObjectMapper((JsonFactory)yamlFactory).registerModule((Module)javaTimeModule);
    }

    @Bean
    public ObjectInputFilter objectInputFilter(PeerForwarderConfiguration peerForwarderConfiguration) {
        String baseModelPackage = "org.opensearch.dataprepper.model";
        Integer maxArrayLength = peerForwarderConfiguration.getForwardingBatchSize();
        if (maxArrayLength == null) {
            maxArrayLength = 15000;
        } else if (maxArrayLength < 10) {
            maxArrayLength = 10;
        }
        String pattern = "maxarray=" + maxArrayLength + ";maxdepth=10;java.lang.Object;java.util.Collections*;java.util.ArrayList*;java.util.LinkedList*;java.util.Map*;java.util.HashMap*;java.util.LinkedHashMap*;java.util.HashSet*;java.util.LinkedHashSet*;java.util.Date*;java.time.*;com.fasterxml.jackson.databind.node.NodeSerialization;com.fasterxml.jackson.databind.node.ObjectNode;com.fasterxml.jackson.databind.node.ArrayNode;org.opensearch.dataprepper.core.peerforwarder.model.*;org.opensearch.dataprepper.model.event.*;org.opensearch.dataprepper.model.trace.*;org.opensearch.dataprepper.model.log.*;org.opensearch.dataprepper.model.metric.*;org.opensearch.dataprepper.model.document.*;com.google.common.collect.ImmutableMap*;com.google.common.collect.RegularImmutableMap*;!*";
        ObjectInputFilter filter = ObjectInputFilter.Config.createFilter(pattern);
        return new LoggingObjectInputFilter(filter);
    }
}

