/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder.codec;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.core.peerforwarder.codec.PeerForwarderCodec;
import org.opensearch.dataprepper.core.peerforwarder.model.PeerForwardingEvents;
import org.opensearch.dataprepper.core.peerforwarder.model.WireEvent;
import org.opensearch.dataprepper.core.peerforwarder.model.WireEvents;
import org.opensearch.dataprepper.model.event.DefaultEventMetadata;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventMetadata;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.trace.JacksonSpan;

public class JacksonPeerForwarderCodec
implements PeerForwarderCodec {
    private static final String TRACE_EVENT_TYPE = "TRACE";
    private final ObjectMapper objectMapper;

    public JacksonPeerForwarderCodec(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public byte[] serialize(PeerForwardingEvents peerForwardingEvents) throws IOException {
        WireEvents wireEvents = this.fromPeerForwardingEventsToWireEvents(peerForwardingEvents);
        return this.objectMapper.writeValueAsBytes((Object)wireEvents);
    }

    @Override
    public PeerForwardingEvents deserialize(byte[] bytes) throws IOException {
        WireEvents wireEvents = (WireEvents)this.objectMapper.readValue(bytes, WireEvents.class);
        return this.fromWireEventsToPeerForwardingEvents(wireEvents);
    }

    private WireEvents fromPeerForwardingEventsToWireEvents(PeerForwardingEvents peerForwardingEvents) {
        List wireEventList = null;
        if (peerForwardingEvents.getEvents() != null) {
            wireEventList = peerForwardingEvents.getEvents().stream().map(event -> new WireEvent(event.getMetadata().getEventType(), event.getMetadata().getTimeReceived(), event.getMetadata().getAttributes(), event.toJsonString())).collect(Collectors.toList());
        }
        return new WireEvents(wireEventList, peerForwardingEvents.getDestinationPluginId(), peerForwardingEvents.getDestinationPipelineName());
    }

    private PeerForwardingEvents fromWireEventsToPeerForwardingEvents(WireEvents wireEvents) {
        List eventList = null;
        if (wireEvents.getEvents() != null) {
            eventList = wireEvents.getEvents().stream().map(this::transformWireEvent).collect(Collectors.toList());
        }
        return new PeerForwardingEvents(eventList, wireEvents.getDestinationPluginId(), wireEvents.getDestinationPipelineName());
    }

    private Event transformWireEvent(WireEvent wireEvent) {
        DefaultEventMetadata eventMetadata = this.getEventMetadata(wireEvent);
        Object event = wireEvent.getEventType().equalsIgnoreCase(TRACE_EVENT_TYPE) ? JacksonSpan.builder().withJsonData(wireEvent.getEventData()).withEventMetadata((EventMetadata)eventMetadata).build() : JacksonEvent.builder().withData((Object)wireEvent.getEventData()).withEventMetadata((EventMetadata)eventMetadata).build();
        return event;
    }

    private DefaultEventMetadata getEventMetadata(WireEvent wireEvent) {
        return DefaultEventMetadata.builder().withEventType(wireEvent.getEventType()).withTimeReceived(wireEvent.getEventTimeReceived()).withAttributes(wireEvent.getEventAttributes()).build();
    }
}

