/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarder;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderProvider;
import org.opensearch.dataprepper.core.peerforwarder.exception.EmptyPeerForwarderPluginIdentificationKeysException;
import org.opensearch.dataprepper.core.peerforwarder.exception.UnsupportedPeerForwarderPluginException;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.peerforwarder.RequiresPeerForwarding;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;

public class PeerForwardingProcessorDecorator
implements Processor<Record<Event>, Record<Event>> {
    private final PeerForwarder peerForwarder;
    private final Processor innerProcessor;
    private final boolean peerForwardingDisabled;

    public static List<Processor> decorateProcessors(List<Processor> processors, PeerForwarderProvider peerForwarderProvider, String pipelineName, String pluginId, Set<Set<String>> excludeIdentificationKeys, Integer pipelineWorkerThreads) {
        if (processors.isEmpty()) {
            return Collections.emptyList();
        }
        Processor firstInnerProcessor = processors.get(0);
        if (!(firstInnerProcessor instanceof RequiresPeerForwarding)) {
            throw new UnsupportedPeerForwarderPluginException("Peer Forwarding is only supported for plugins which implement RequiresPeerForwarding interface.");
        }
        HashSet<String> identificationKeys = new HashSet<String>(((RequiresPeerForwarding)firstInnerProcessor).getIdentificationKeys());
        processors.forEach(processor -> {
            HashSet processorIdentificationKeys;
            if (processor instanceof RequiresPeerForwarding && !identificationKeys.equals(processorIdentificationKeys = new HashSet(((RequiresPeerForwarding)processor).getIdentificationKeys()))) {
                throw new RuntimeException("All the processors of same type within a single pipeline should have same identification keys.");
            }
        });
        if (identificationKeys.isEmpty()) {
            throw new EmptyPeerForwarderPluginIdentificationKeysException("Peer Forwarder Plugin: %s cannot have empty identification keys." + pluginId);
        }
        PeerForwarder peerForwarder = peerForwarderProvider.register(pipelineName, firstInnerProcessor, pluginId, identificationKeys, pipelineWorkerThreads);
        return processors.stream().map(processor -> new PeerForwardingProcessorDecorator(peerForwarder, (Processor)processor, PeerForwardingProcessorDecorator.isPeerForwardingDisabled(processor, excludeIdentificationKeys))).collect(Collectors.toList());
    }

    private static boolean isPeerForwardingDisabled(Processor processor, Set<Set<String>> excludeIdentificationKeysSet) {
        if (processor instanceof RequiresPeerForwarding && excludeIdentificationKeysSet != null && excludeIdentificationKeysSet.size() > 0) {
            HashSet identificationKeys = new HashSet(((RequiresPeerForwarding)processor).getIdentificationKeys());
            return excludeIdentificationKeysSet.contains(identificationKeys);
        }
        return false;
    }

    private PeerForwardingProcessorDecorator(PeerForwarder peerForwarder, Processor innerProcessor, boolean peerForwardingDisabled) {
        this.peerForwarder = peerForwarder;
        this.innerProcessor = innerProcessor;
        this.peerForwardingDisabled = peerForwardingDisabled;
    }

    boolean isPeerForwardingDisabled() {
        return this.peerForwardingDisabled;
    }

    public Collection<Record<Event>> execute(Collection<Record<Event>> records) {
        ArrayList<Record<Event>> recordsToProcess = new ArrayList<Record<Event>>();
        Collection<Record<Event>> recordsToProcessLocally = new ArrayList();
        ArrayList<Record<Event>> recordsSkipped = new ArrayList<Record<Event>>();
        for (Record<Event> record : records) {
            if (((RequiresPeerForwarding)this.innerProcessor).isApplicableEventForPeerForwarding((Event)record.getData())) {
                if (this.isPeerForwardingDisabled()) {
                    recordsToProcessLocally.add(record);
                    continue;
                }
                recordsToProcess.add(record);
                continue;
            }
            if (((RequiresPeerForwarding)this.innerProcessor).isForLocalProcessingOnly((Event)record.getData())) {
                recordsToProcessLocally.add(record);
                continue;
            }
            recordsSkipped.add(record);
        }
        Collection<Record<Event>> recordsToProcessOnLocalPeer = this.peerForwarder.forwardRecords(recordsToProcess);
        recordsToProcessLocally = CollectionUtils.union(recordsToProcessLocally, recordsToProcessOnLocalPeer);
        Collection<Record<Event>> receivedRecordsFromBuffer = this.peerForwarder.receiveRecords();
        recordsToProcessLocally = CollectionUtils.union(recordsToProcessLocally, receivedRecordsFromBuffer);
        Collection recordsOut = this.innerProcessor.execute(recordsToProcessLocally);
        recordsOut.addAll(recordsSkipped);
        return recordsOut;
    }

    public void prepareForShutdown() {
        this.innerProcessor.prepareForShutdown();
    }

    public boolean isReadyForShutdown() {
        return this.innerProcessor.isReadyForShutdown();
    }

    public void shutdown() {
        this.innerProcessor.shutdown();
    }
}

