/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opensearch.dataprepper.core.peerforwarder.HashRing;
import org.opensearch.dataprepper.core.peerforwarder.LocalPeerForwarder;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarder;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderClientFactory;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderConfiguration;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderProvider;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderReceiveBuffer;
import org.opensearch.dataprepper.core.peerforwarder.RemotePeerForwarder;
import org.opensearch.dataprepper.core.peerforwarder.client.PeerForwarderClient;
import org.opensearch.dataprepper.core.peerforwarder.discovery.DiscoveryMode;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;

public class DefaultPeerForwarderProvider
implements PeerForwarderProvider {
    private final PeerForwarderClientFactory peerForwarderClientFactory;
    private final PeerForwarderClient peerForwarderClient;
    private final PeerForwarderConfiguration peerForwarderConfiguration;
    private final PluginMetrics pluginMetrics;
    private final Map<String, Map<String, PeerForwarderReceiveBuffer<Record<Event>>>> pipelinePeerForwarderReceiveBufferMap = new HashMap<String, Map<String, PeerForwarderReceiveBuffer<Record<Event>>>>();
    private HashRing hashRing;

    DefaultPeerForwarderProvider(PeerForwarderClientFactory peerForwarderClientFactory, PeerForwarderClient peerForwarderClient, PeerForwarderConfiguration peerForwarderConfiguration, PluginMetrics pluginMetrics) {
        this.peerForwarderClientFactory = peerForwarderClientFactory;
        this.peerForwarderClient = peerForwarderClient;
        this.peerForwarderConfiguration = peerForwarderConfiguration;
        this.pluginMetrics = pluginMetrics;
    }

    @Override
    public PeerForwarder register(String pipelineName, Processor processor, String pluginId, Set<String> identificationKeys, Integer pipelineWorkerThreads) {
        if (this.pipelinePeerForwarderReceiveBufferMap.containsKey(pipelineName) && this.pipelinePeerForwarderReceiveBufferMap.get(pipelineName).containsKey(pluginId)) {
            throw new RuntimeException("Data Prepper 2.0 will only support a single peer-forwarder per pipeline/plugin type");
        }
        PeerForwarderReceiveBuffer<Record<Event>> peerForwarderReceiveBuffer = this.createBufferPerPipelineProcessor(pipelineName, pluginId);
        if (this.isPeerForwardingRequired()) {
            if (this.hashRing == null) {
                this.hashRing = this.peerForwarderClientFactory.createHashRing();
            }
            return new RemotePeerForwarder(this.peerForwarderClient, this.hashRing, peerForwarderReceiveBuffer, pipelineName, pluginId, identificationKeys, this.pluginMetrics, this.peerForwarderConfiguration.getBatchDelay(), this.peerForwarderConfiguration.getFailedForwardingRequestLocalWriteTimeout(), this.peerForwarderConfiguration.getForwardingBatchSize(), this.peerForwarderConfiguration.getForwardingBatchQueueDepth(), this.peerForwarderConfiguration.getForwardingBatchTimeout(), pipelineWorkerThreads);
        }
        return new LocalPeerForwarder();
    }

    private PeerForwarderReceiveBuffer<Record<Event>> createBufferPerPipelineProcessor(String pipelineName, String pluginId) {
        PeerForwarderReceiveBuffer<Record<Event>> peerForwarderReceiveBuffer = new PeerForwarderReceiveBuffer<Record<Event>>(this.peerForwarderConfiguration.getBufferSize(), this.peerForwarderConfiguration.getBatchSize(), pipelineName, pluginId);
        Map pluginsBufferMap = this.pipelinePeerForwarderReceiveBufferMap.computeIfAbsent(pipelineName, k -> new HashMap());
        pluginsBufferMap.put(pluginId, peerForwarderReceiveBuffer);
        return peerForwarderReceiveBuffer;
    }

    @Override
    public boolean isPeerForwardingRequired() {
        return this.arePeersConfigured() && this.pipelinePeerForwarderReceiveBufferMap.size() > 0;
    }

    @Override
    public boolean arePeersConfigured() {
        DiscoveryMode discoveryMode = this.peerForwarderConfiguration.getDiscoveryMode();
        if (discoveryMode.equals((Object)DiscoveryMode.LOCAL_NODE)) {
            return false;
        }
        return !discoveryMode.equals((Object)DiscoveryMode.STATIC) || this.peerForwarderConfiguration.getStaticEndpoints().size() > 1;
    }

    @Override
    public Map<String, Map<String, PeerForwarderReceiveBuffer<Record<Event>>>> getPipelinePeerForwarderReceiveBufferMap() {
        return this.pipelinePeerForwarderReceiveBufferMap;
    }
}

