/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.parser.config;

import org.opensearch.dataprepper.core.breaker.CircuitBreakerManager;
import org.opensearch.dataprepper.core.parser.PipelineTransformer;
import org.opensearch.dataprepper.core.parser.config.FileStructurePathProvider;
import org.opensearch.dataprepper.core.parser.model.DataPrepperConfiguration;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderProvider;
import org.opensearch.dataprepper.core.pipeline.router.RouterFactory;
import org.opensearch.dataprepper.core.sourcecoordination.SourceCoordinatorFactory;
import org.opensearch.dataprepper.core.validation.PluginErrorCollector;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.configuration.PipelinesDataFlowModel;
import org.opensearch.dataprepper.model.event.EventFactory;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.pipeline.parser.PipelineConfigurationFileReader;
import org.opensearch.dataprepper.pipeline.parser.PipelineConfigurationReader;
import org.opensearch.dataprepper.pipeline.parser.PipelinesDataflowModelParser;
import org.opensearch.dataprepper.pipeline.parser.rule.RuleEvaluator;
import org.opensearch.dataprepper.pipeline.parser.transformer.DynamicConfigTransformer;
import org.opensearch.dataprepper.pipeline.parser.transformer.PipelineConfigurationTransformer;
import org.opensearch.dataprepper.validation.PluginErrorsHandler;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ComponentScan(basePackages={"org.opensearch.dataprepper.pipeline.parser", "org.opensearch.dataprepper.plugin"})
public class PipelineParserConfiguration {
    @Bean
    public PipelineTransformer pipelineParser(PluginFactory pluginFactory, PeerForwarderProvider peerForwarderProvider, RouterFactory routerFactory, DataPrepperConfiguration dataPrepperConfiguration, CircuitBreakerManager circuitBreakerManager, EventFactory eventFactory, AcknowledgementSetManager acknowledgementSetManager, SourceCoordinatorFactory sourceCoordinatorFactory, PluginErrorCollector pluginErrorCollector, PluginErrorsHandler pluginErrorsHandler, ExpressionEvaluator expressionEvaluator) {
        return new PipelineTransformer(pluginFactory, peerForwarderProvider, routerFactory, dataPrepperConfiguration, circuitBreakerManager, eventFactory, acknowledgementSetManager, sourceCoordinatorFactory, pluginErrorCollector, pluginErrorsHandler, expressionEvaluator);
    }

    @Bean
    public PipelineConfigurationReader pipelineConfigurationReader(FileStructurePathProvider fileStructurePathProvider) {
        return new PipelineConfigurationFileReader(fileStructurePathProvider.getPipelineConfigFileLocation());
    }

    @Bean
    public PipelinesDataflowModelParser pipelinesDataflowModelParser(PipelineConfigurationReader pipelineConfigurationReader) {
        return new PipelinesDataflowModelParser(pipelineConfigurationReader);
    }

    @Bean
    public PipelineConfigurationTransformer pipelineConfigTransformer(RuleEvaluator ruleEvaluator) {
        return new DynamicConfigTransformer(ruleEvaluator);
    }

    @Bean(name={"pipelinesDataFlowModel"})
    @Primary
    public PipelinesDataFlowModel pipelinesDataFlowModel(PipelineConfigurationTransformer pipelineConfigTransformer, @Qualifier(value="preTransformedDataFlowModel") PipelinesDataFlowModel preTransformedDataFlowModel) {
        return pipelineConfigTransformer.transformConfiguration(preTransformedDataFlowModel);
    }

    @Bean(name={"preTransformedDataFlowModel"})
    public PipelinesDataFlowModel preTransformedDataFlowModel(PipelinesDataflowModelParser pipelinesDataflowModelParser) {
        return pipelinesDataflowModelParser.parseConfiguration();
    }
}

