/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.parser.config;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class DisableMetricsFilter
implements MeterFilter {
    private static final Logger LOG = LoggerFactory.getLogger(DisableMetricsFilter.class);
    private final List<String> disabledPatterns;
    private static final AntPathMatcher matcher = new AntPathMatcher(".");

    public DisableMetricsFilter(List<String> disabledPatterns) {
        this.disabledPatterns = disabledPatterns != null ? disabledPatterns : Collections.emptyList();
    }

    public MeterFilterReply accept(Meter.Id id) {
        String metricName = id.getName();
        for (String pattern : this.disabledPatterns) {
            if (!matcher.match(pattern, metricName)) continue;
            return MeterFilterReply.DENY;
        }
        return MeterFilterReply.NEUTRAL;
    }
}

