/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.parser;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.opensearch.dataprepper.model.breaker.CircuitBreaker;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.buffer.DelegatingBuffer;
import org.opensearch.dataprepper.model.record.Record;

class CircuitBreakingBuffer<T extends Record<?>>
extends DelegatingBuffer<T>
implements Buffer<T> {
    private final CircuitBreaker circuitBreaker;

    public CircuitBreakingBuffer(Buffer<T> buffer, CircuitBreaker circuitBreaker) {
        super(buffer);
        this.circuitBreaker = Objects.requireNonNull(circuitBreaker);
    }

    public void write(T record, int timeoutInMillis) throws TimeoutException {
        this.checkBreaker();
        super.write(record, timeoutInMillis);
    }

    public void writeAll(Collection<T> records, int timeoutInMillis) throws Exception {
        this.checkBreaker();
        super.writeAll(records, timeoutInMillis);
    }

    public void writeBytes(byte[] bytes, String key, int timeoutInMillis) throws Exception {
        this.checkBreaker();
        super.writeBytes(bytes, key, timeoutInMillis);
    }

    private void checkBreaker() throws TimeoutException {
        if (this.circuitBreaker.isOpen()) {
            throw new TimeoutException("Circuit breaker is open. Unable to write to buffer.");
        }
    }
}

