/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.acknowledgements;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.opensearch.dataprepper.core.acknowledgements.DefaultAcknowledgementSetMetrics;
import org.opensearch.dataprepper.core.acknowledgements.DefaultProgressCheck;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.acknowledgements.ProgressCheck;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.model.event.InternalEventHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAcknowledgementSet
implements AcknowledgementSet {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAcknowledgementSet.class);
    private final Consumer<Boolean> callback;
    private Consumer<ProgressCheck> progressCheckCallback;
    private Instant expiryTime;
    private final ScheduledExecutorService scheduledExecutor;
    private final ReentrantLock lock;
    private boolean result;
    private final Map<EventHandle, AtomicInteger> pendingAcknowledgments;
    private Future<?> callbackFuture;
    private final DefaultAcknowledgementSetMetrics metrics;
    private ScheduledFuture<?> progressCheckFuture;
    private boolean completed;
    private AtomicInteger totalEventsAdded;

    public DefaultAcknowledgementSet(ScheduledExecutorService scheduledExecutor, Consumer<Boolean> callback, Duration expiryTime, DefaultAcknowledgementSetMetrics metrics) {
        this.callback = callback;
        this.result = true;
        this.totalEventsAdded = new AtomicInteger(0);
        this.scheduledExecutor = scheduledExecutor;
        this.expiryTime = Instant.now().plusMillis(expiryTime.toMillis());
        this.callbackFuture = null;
        this.metrics = metrics;
        this.completed = false;
        this.progressCheckCallback = null;
        this.pendingAcknowledgments = new HashMap<EventHandle, AtomicInteger>();
        this.lock = new ReentrantLock(true);
    }

    public void addProgressCheck(Consumer<ProgressCheck> progressCheckCallback, Duration progressCheckInterval) {
        this.progressCheckCallback = progressCheckCallback;
        this.progressCheckFuture = this.scheduledExecutor.scheduleAtFixedRate(this::checkProgress, 0L, progressCheckInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void increaseExpiry(Duration expiryIncreaseTime) {
        this.expiryTime = Instant.now().plus(expiryIncreaseTime);
    }

    public Instant getExpirationTime() {
        return this.expiryTime;
    }

    public void cancel() {
        if (this.progressCheckFuture != null) {
            this.progressCheckFuture.cancel(true);
        }
        if (this.callbackFuture != null) {
            this.callbackFuture.cancel(false);
        }
    }

    public void checkProgress() {
        this.lock.lock();
        int numberOfEventsPending = this.pendingAcknowledgments.size();
        this.lock.unlock();
        if (this.progressCheckCallback != null) {
            this.progressCheckCallback.accept(new DefaultProgressCheck((double)numberOfEventsPending / (double)this.totalEventsAdded.get()));
        }
    }

    public void add(EventHandle eventHandle) {
        this.lock.lock();
        try {
            InternalEventHandle internalEventHandle = (InternalEventHandle)eventHandle;
            internalEventHandle.addAcknowledgementSet((AcknowledgementSet)this);
            this.pendingAcknowledgments.put(eventHandle, new AtomicInteger(1));
            this.totalEventsAdded.incrementAndGet();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void acquire(EventHandle eventHandle) {
        this.lock.lock();
        try {
            if (!this.pendingAcknowledgments.containsKey(eventHandle)) {
                LOG.warn("Unexpected event handle acquire");
                this.metrics.increment("numberOfInvalidAcknowledgementAcquires");
                return;
            }
            this.pendingAcknowledgments.get(eventHandle).incrementAndGet();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isDone() {
        this.lock.lock();
        try {
            if (this.callbackFuture != null && this.callbackFuture.isDone()) {
                this.metrics.increment("numberOfAcknowledgementSetsCompleted");
                boolean bl = true;
                return bl;
            }
            if (Instant.now().isAfter(this.expiryTime)) {
                if (this.progressCheckFuture != null) {
                    this.progressCheckFuture.cancel(false);
                }
                if (this.callbackFuture != null) {
                    this.callbackFuture.cancel(true);
                    this.callbackFuture = null;
                    LOG.warn("AcknowledgementSet expired");
                }
                this.metrics.increment("numberOfAcknowledgementSetsExpired");
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    public Instant getExpiryTime() {
        return this.expiryTime;
    }

    public void complete() {
        this.lock.lock();
        try {
            this.completed = true;
            if (this.pendingAcknowledgments.size() == 0) {
                if (this.progressCheckFuture != null) {
                    this.progressCheckFuture.cancel(false);
                }
                this.callbackFuture = this.scheduledExecutor.submit(() -> this.callback.accept(this.result));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(EventHandle eventHandle, boolean result) {
        this.lock.lock();
        this.result = this.result && result;
        try {
            if (!this.pendingAcknowledgments.containsKey(eventHandle) || this.pendingAcknowledgments.get(eventHandle).get() == 0) {
                boolean bl = false;
                return bl;
            }
            if (this.pendingAcknowledgments.get(eventHandle).decrementAndGet() == 0) {
                this.pendingAcknowledgments.remove(eventHandle);
                if (this.completed && this.pendingAcknowledgments.size() == 0) {
                    if (this.progressCheckFuture != null) {
                        this.progressCheckFuture.cancel(false);
                    }
                    this.callbackFuture = this.scheduledExecutor.submit(() -> this.callback.accept(this.result));
                    boolean bl = true;
                    return bl;
                }
                if (this.pendingAcknowledgments.size() == 0) {
                    LOG.debug("Acknowledgement set is not completed. Delaying callback until it is completed");
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }
}

