/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.oteltrace;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.Duration;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>otel_traces</code> processor completes trace-group-related fields in all incoming span records by state caching the root span information for each <code>traceId</code>.")
public class OtelTraceRawProcessorConfig {
    static final long DEFAULT_TG_FLUSH_INTERVAL_SEC = 180L;
    static final Duration DEFAULT_TRACE_ID_TTL = Duration.ofSeconds(15L);
    static final long MAX_TRACE_ID_CACHE_SIZE = 1000000L;
    @JsonProperty(value="trace_flush_interval", defaultValue="180")
    @JsonPropertyDescription(value="Represents the time interval in seconds to flush all the descendant spans without any root span. Default is <code>180</code>.")
    private long traceFlushInterval = 180L;
    @JsonProperty(value="trace_group_cache_ttl", defaultValue="PT15S")
    @JsonPropertyDescription(value="Represents the time-to-live to cache a trace group details. The value may be an ISO 8601 notation such as <code>PT1M30S</code> or a duration and unit such as <code>45s</code>. Default is 15 seconds.")
    private Duration traceGroupCacheTimeToLive = DEFAULT_TRACE_ID_TTL;
    @JsonProperty(value="trace_group_cache_max_size", defaultValue="1000000")
    @JsonPropertyDescription(value="Represents the maximum size of the cache to store the trace group details from root spans. Default is <code>1000000</code>.")
    private long traceGroupCacheMaxSize = 1000000L;

    public long getTraceFlushIntervalSeconds() {
        return this.traceFlushInterval;
    }

    public Duration getTraceGroupCacheTimeToLive() {
        return this.traceGroupCacheTimeToLive;
    }

    public long getTraceGroupCacheMaxSize() {
        return this.traceGroupCacheMaxSize;
    }
}

