/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensearch.dataprepper.model.plugin.PluginConfigValueTranslator;
import org.opensearch.dataprepper.model.plugin.PluginConfigVariable;

@Named
public class VariableExpander {
    static final String VALUE_REFERENCE_KEY = "valueReferenceKey";
    static final String SECRETS_REFERENCE_PATTERN_STRING = "^\\$\\{\\{%s\\:(?<%s>.*)\\}\\}$";
    private final Map<Pattern, PluginConfigValueTranslator> patternPluginConfigValueTranslatorMap;
    private final ObjectMapper objectMapper;

    @Inject
    public VariableExpander(@Named(value="extensionPluginConfigObjectMapper") ObjectMapper objectMapper, Set<PluginConfigValueTranslator> pluginConfigValueTranslators) {
        this.objectMapper = objectMapper;
        this.patternPluginConfigValueTranslatorMap = pluginConfigValueTranslators.stream().collect(Collectors.toMap(pluginConfigValueTranslator -> Pattern.compile(String.format(SECRETS_REFERENCE_PATTERN_STRING, pluginConfigValueTranslator.getPrefix(), VALUE_REFERENCE_KEY)), Function.identity()));
    }

    public <T> T translate(JsonParser jsonParser, Class<T> destinationType) throws IOException {
        if (JsonToken.VALUE_STRING.equals((Object)jsonParser.currentToken())) {
            String rawValue = jsonParser.getValueAsString();
            return (T)this.patternPluginConfigValueTranslatorMap.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<Matcher, PluginConfigValueTranslator>(((Pattern)entry.getKey()).matcher(rawValue), (PluginConfigValueTranslator)entry.getValue())).filter(entry -> ((Matcher)entry.getKey()).matches()).map(entry -> {
                String valueReferenceKey = ((Matcher)entry.getKey()).group(VALUE_REFERENCE_KEY);
                if (destinationType.equals(PluginConfigVariable.class)) {
                    return ((PluginConfigValueTranslator)entry.getValue()).translateToPluginConfigVariable(valueReferenceKey);
                }
                return this.objectMapper.convertValue(((PluginConfigValueTranslator)entry.getValue()).translate(valueReferenceKey), destinationType);
            }).findFirst().orElseGet(() -> {
                if (destinationType.equals(PluginConfigVariable.class)) {
                    return destinationType.cast(new ImmutablePluginConfigVariable(rawValue));
                }
                return this.objectMapper.convertValue((Object)rawValue, destinationType);
            });
        }
        return (T)this.objectMapper.readValue(jsonParser, destinationType);
    }

    private static class ImmutablePluginConfigVariable
    implements PluginConfigVariable {
        private final Object rawValue;

        private ImmutablePluginConfigVariable(Object rawValue) {
            this.rawValue = rawValue;
        }

        public Object getValue() {
            return this.rawValue;
        }

        public void setValue(Object updatedValue) {
            throw new UnsupportedOperationException("ImmutablePluginConfigVariable doesn't support this operation");
        }

        public void refresh() {
            throw new UnsupportedOperationException("ImmutablePluginConfigVariable doesn't support this operation");
        }

        public boolean isUpdatable() {
            return false;
        }
    }
}

