/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PluginPackagesSupplier
implements Supplier<String[]> {
    private static final Logger LOG = LoggerFactory.getLogger(PluginPackagesSupplier.class);
    private static final String DEFAULT_PLUGINS_CLASSPATH = "org.opensearch.dataprepper.plugins";
    private static final String DEPRECATED_DEFAULT_PLUGINS_CLASSPATH = "com.amazon.dataprepper.plugins";

    PluginPackagesSupplier() {
    }

    Iterator<URL> loadResources() throws IOException {
        Enumeration<URL> resourcesEnumeration = this.getClass().getClassLoader().getResources("META-INF/data-prepper.plugins.properties");
        return Iterators.forEnumeration(resourcesEnumeration);
    }

    @Override
    public String[] get() {
        Set<String> packageNames = this.getUniquePackageNames();
        CharSequence[] packageNamesArray = packageNames.toArray(new String[0]);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using packages for plugins: {}", (Object)String.join((CharSequence)",", packageNamesArray));
        }
        return packageNamesArray;
    }

    private Set<String> getUniquePackageNames() {
        Set<String> packageNames;
        try {
            Iterator<URL> pluginResources = this.loadResources();
            packageNames = this.readResources(pluginResources);
        }
        catch (IOException ex) {
            LOG.warn("Unable to load data-prepper.plugins.properties file. Reverting to default plugin package.");
            packageNames = new LinkedHashSet<String>(Arrays.asList(DEFAULT_PLUGINS_CLASSPATH, DEPRECATED_DEFAULT_PLUGINS_CLASSPATH));
        }
        return packageNames;
    }

    private Set<String> readResources(Iterator<URL> pluginResources) {
        HashSet<String> packageNames = new HashSet<String>();
        while (pluginResources.hasNext()) {
            URL pluginPropertiesUrl = pluginResources.next();
            Properties pluginProperties = new Properties();
            try {
                InputStream pluginPropertiesInputStream = pluginPropertiesUrl.openStream();
                pluginProperties.load(pluginPropertiesInputStream);
            }
            catch (IOException ex) {
                LOG.warn("Unable to load properties from resource. url={}", (Object)pluginPropertiesUrl, (Object)ex);
            }
            String packagesRawString = pluginProperties.getProperty("org.opensearch.dataprepper.plugin.packages", "");
            String[] currentPackageNames = packagesRawString.split(",");
            List validPackageNames = Arrays.stream(currentPackageNames).filter(p -> !p.isEmpty()).collect(Collectors.toList());
            packageNames.addAll(validPackageNames);
        }
        if (packageNames.isEmpty()) {
            LOG.warn("Unable to load packages from data-prepper.plugins.properties file. Reverting to default plugin package.");
            packageNames.add(DEFAULT_PLUGINS_CLASSPATH);
            packageNames.add(DEPRECATED_DEFAULT_PLUGINS_CLASSPATH);
        }
        return packageNames;
    }
}

