/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensearch.dataprepper.core.validation.PluginErrorCollector;
import org.opensearch.dataprepper.model.annotations.DataPrepperExtensionPlugin;
import org.opensearch.dataprepper.model.plugin.ExtensionPlugin;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.plugin.InvalidPluginDefinitionException;
import org.opensearch.dataprepper.plugin.ExtensionClassProvider;
import org.opensearch.dataprepper.plugin.ExtensionPluginConfigurationConverter;
import org.opensearch.dataprepper.plugin.PluginArgumentsContext;
import org.opensearch.dataprepper.plugin.PluginCreator;
import org.opensearch.dataprepper.validation.PluginError;
import org.opensearch.dataprepper.validation.PluginErrorsHandler;

@Named
public class ExtensionLoader {
    private final ExtensionPluginConfigurationConverter extensionPluginConfigurationConverter;
    private final ExtensionClassProvider extensionClassProvider;
    private final PluginCreator extensionPluginCreator;
    private final PluginErrorCollector pluginErrorCollector;
    private final PluginErrorsHandler pluginErrorsHandler;

    @Inject
    ExtensionLoader(ExtensionPluginConfigurationConverter extensionPluginConfigurationConverter, ExtensionClassProvider extensionClassProvider, @Named(value="extensionPluginCreator") PluginCreator extensionPluginCreator, PluginErrorCollector pluginErrorCollector, PluginErrorsHandler pluginErrorsHandler) {
        this.extensionPluginConfigurationConverter = extensionPluginConfigurationConverter;
        this.extensionClassProvider = extensionClassProvider;
        this.extensionPluginCreator = extensionPluginCreator;
        this.pluginErrorCollector = pluginErrorCollector;
        this.pluginErrorsHandler = pluginErrorsHandler;
    }

    public List<? extends ExtensionPlugin> loadExtensions() {
        List result = this.extensionClassProvider.loadExtensionPluginClasses().stream().map(extensionClass -> {
            String pluginName = this.convertClassToName((Class<? extends ExtensionPlugin>)extensionClass);
            try {
                PluginArgumentsContext pluginArgumentsContext = this.getConstructionContext((Class<?>)extensionClass);
                return (ExtensionPlugin)this.extensionPluginCreator.newPluginInstance(extensionClass, pluginArgumentsContext, pluginName, new Object[0]);
            }
            catch (Exception e) {
                PluginError pluginError = PluginError.builder().componentType("extension").pluginName(pluginName).exception(e).build();
                this.pluginErrorCollector.collectPluginError(pluginError);
                return null;
            }
        }).collect(Collectors.toList());
        List extensionPluginErrors = this.pluginErrorCollector.getPluginErrors().stream().filter(pluginError -> "extension".equals(pluginError.getComponentType())).collect(Collectors.toList());
        if (!extensionPluginErrors.isEmpty()) {
            this.pluginErrorsHandler.handleErrors(extensionPluginErrors);
            throw new InvalidPluginConfigurationException("One or more extension plugins are not configured correctly.");
        }
        return result;
    }

    private PluginArgumentsContext getConstructionContext(Class<?> extensionPluginClass) {
        DataPrepperExtensionPlugin pluginAnnotation = extensionPluginClass.getAnnotation(DataPrepperExtensionPlugin.class);
        if (pluginAnnotation == null) {
            return new NoArgumentsArgumentsContext();
        }
        Class pluginConfigurationType = pluginAnnotation.modelType();
        String rootKey = pluginAnnotation.rootKeyJsonPath();
        Object configuration = this.extensionPluginConfigurationConverter.convert(pluginAnnotation.allowInPipelineConfigurations(), pluginConfigurationType, rootKey);
        return new SingleConfigArgumentArgumentsContext(configuration);
    }

    private String convertClassToName(Class<? extends ExtensionPlugin> extensionClass) {
        String className = extensionClass.getSimpleName();
        return ExtensionLoader.classNameToPluginName(className);
    }

    static String classNameToPluginName(String className) {
        String[] words = className.split("(?=\\p{Upper})");
        return Arrays.stream(words).map(String::toLowerCase).collect(Collectors.joining("_")).replace("$", "");
    }

    protected static class SingleConfigArgumentArgumentsContext
    implements PluginArgumentsContext {
        private final Object extensionPluginConfiguration;

        SingleConfigArgumentArgumentsContext(Object extensionPluginConfiguration) {
            this.extensionPluginConfiguration = extensionPluginConfiguration;
        }

        @Override
        public Object[] createArguments(Class<?>[] parameterTypes, Object ... args) {
            if (parameterTypes.length != 1 && Objects.nonNull(this.extensionPluginConfiguration) && !parameterTypes[0].equals(this.extensionPluginConfiguration.getClass())) {
                throw new InvalidPluginDefinitionException(String.format("Single %s argument is permitted for extensions constructors.", this.extensionPluginConfiguration.getClass()));
            }
            return new Object[]{this.extensionPluginConfiguration};
        }
    }

    protected static class NoArgumentsArgumentsContext
    implements PluginArgumentsContext {
        protected NoArgumentsArgumentsContext() {
        }

        @Override
        public Object[] createArguments(Class<?>[] parameterTypes, Object ... args) {
            if (parameterTypes.length != 0) {
                throw new InvalidPluginDefinitionException("No arguments are permitted for extensions constructors.");
            }
            return new Object[0];
        }
    }
}

