/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.configuration.PipelineDescription;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.plugin.InvalidPluginDefinitionException;
import org.opensearch.dataprepper.model.plugin.PluginConfigObservable;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.sink.SinkContext;
import org.opensearch.dataprepper.plugin.PluginArgumentsContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;

class ComponentPluginArgumentsContext
implements PluginArgumentsContext {
    private static final String UNABLE_TO_CREATE_PLUGIN_PARAMETER = "Unable to create an argument for required plugin parameter type: ";
    private final Map<Class<?>, Supplier<Object>> typedArgumentsSuppliers;
    @Nullable
    private final BeanFactory beanFactory;

    private ComponentPluginArgumentsContext(Builder builder) {
        Objects.requireNonNull(builder.pluginSetting, "PluginArgumentsContext received a null Builder object. This is likely an error in the plugin framework.");
        this.beanFactory = builder.beanFactory;
        this.typedArgumentsSuppliers = new HashMap();
        this.typedArgumentsSuppliers.put(PluginSetting.class, () -> builder.pluginSetting);
        if (builder.pluginConfiguration != null) {
            this.typedArgumentsSuppliers.put(builder.pluginConfiguration.getClass(), () -> builder.pluginConfiguration);
        }
        this.typedArgumentsSuppliers.put(PluginMetrics.class, () -> PluginMetrics.fromPluginSetting((PluginSetting)builder.pluginSetting));
        if (builder.pipelineDescription != null) {
            this.typedArgumentsSuppliers.put(PipelineDescription.class, () -> builder.pipelineDescription);
        }
        if (builder.pluginFactory != null) {
            this.typedArgumentsSuppliers.put(PluginFactory.class, () -> builder.pluginFactory);
        }
        if (builder.sinkContext != null) {
            this.typedArgumentsSuppliers.put(SinkContext.class, () -> builder.sinkContext);
        }
        if (builder.pluginConfigObservable != null) {
            this.typedArgumentsSuppliers.put(PluginConfigObservable.class, () -> builder.pluginConfigObservable);
        }
        if (builder.additionalTypeArgumentSuppliers != null) {
            this.typedArgumentsSuppliers.putAll(builder.additionalTypeArgumentSuppliers);
        }
    }

    @Override
    public Object[] createArguments(Class<?>[] parameterTypes, Object ... args) {
        HashMap optionalArgumentsSuppliers = new HashMap();
        for (Object arg : args) {
            if (!Objects.nonNull(arg)) continue;
            optionalArgumentsSuppliers.put(arg.getClass(), () -> arg);
            for (Class<?> interfaceClass : arg.getClass().getInterfaces()) {
                optionalArgumentsSuppliers.put(interfaceClass, () -> arg);
            }
        }
        return Arrays.stream(parameterTypes).map(parameterType -> this.getRequiredArgumentSupplier((Class<?>)parameterType, optionalArgumentsSuppliers)).map(Supplier::get).toArray();
    }

    private Supplier<Object> getRequiredArgumentSupplier(Class<?> parameterType, Map<Class<?>, Supplier<Object>> optionalArgumentsSuppliers) {
        if (this.typedArgumentsSuppliers.containsKey(parameterType)) {
            return this.typedArgumentsSuppliers.get(parameterType);
        }
        if (optionalArgumentsSuppliers.containsKey(parameterType)) {
            return optionalArgumentsSuppliers.get(parameterType);
        }
        if (this.beanFactory != null) {
            return this.createBeanSupplier(parameterType, this.beanFactory);
        }
        throw new InvalidPluginDefinitionException(UNABLE_TO_CREATE_PLUGIN_PARAMETER + String.valueOf(parameterType));
    }

    private <T> Supplier<T> createBeanSupplier(Class<? extends T> parameterType, BeanFactory beanFactory) {
        return () -> {
            try {
                return beanFactory.getBean(parameterType);
            }
            catch (BeansException e) {
                throw new InvalidPluginDefinitionException(UNABLE_TO_CREATE_PLUGIN_PARAMETER + String.valueOf(parameterType), (Throwable)e);
            }
        };
    }

    static class Builder {
        private Object pluginConfiguration;
        private PluginSetting pluginSetting;
        private PluginFactory pluginFactory;
        private PipelineDescription pipelineDescription;
        private BeanFactory beanFactory;
        private SinkContext sinkContext;
        private PluginConfigObservable pluginConfigObservable;
        private Map<Class<?>, Supplier<Object>> additionalTypeArgumentSuppliers;

        Builder() {
        }

        Builder withPluginConfiguration(Object pluginConfiguration) {
            this.pluginConfiguration = pluginConfiguration;
            return this;
        }

        Builder withPluginSetting(PluginSetting pluginSetting) {
            this.pluginSetting = pluginSetting;
            return this;
        }

        Builder withPluginFactory(PluginFactory pluginFactory) {
            this.pluginFactory = pluginFactory;
            return this;
        }

        Builder withSinkContext(SinkContext sinkContext) {
            this.sinkContext = sinkContext;
            return this;
        }

        Builder withPipelineDescription(PipelineDescription pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
            return this;
        }

        Builder withBeanFactory(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
            return this;
        }

        Builder withPluginConfigurationObservable(PluginConfigObservable pluginConfigObservable) {
            this.pluginConfigObservable = pluginConfigObservable;
            return this;
        }

        Builder withTypeArgumentSuppliers(Map<Class<?>, Supplier<Object>> additionalTypeArgumentSuppliers) {
            this.additionalTypeArgumentSuppliers = additionalTypeArgumentSuppliers;
            return this;
        }

        ComponentPluginArgumentsContext build() {
            return new ComponentPluginArgumentsContext(this);
        }
    }
}

