/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.plugin.PluginPackagesSupplier;
import org.opensearch.dataprepper.plugin.PluginProvider;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathPluginProvider
implements PluginProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathPluginProvider.class);
    private final Reflections reflections;
    private Map<String, Map<Class<?>, Class<?>>> nameToSupportedTypeToPluginType;

    public ClasspathPluginProvider() {
        this(new Reflections((Configuration)new ConfigurationBuilder().forPackages(new PluginPackagesSupplier().get())));
    }

    ClasspathPluginProvider(Reflections reflections) {
        this.reflections = reflections;
    }

    @Override
    public <T> Optional<Class<? extends T>> findPluginClass(Class<T> pluginType, String pluginName) {
        Map<Class<?>, Class<?>> supportedTypesMap;
        if (this.nameToSupportedTypeToPluginType == null) {
            this.nameToSupportedTypeToPluginType = this.scanForPlugins();
        }
        if ((supportedTypesMap = this.nameToSupportedTypeToPluginType.get(pluginName)) == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(supportedTypesMap.get(pluginType));
    }

    public <T> Set<Class<? extends T>> findPluginClasses(Class<T> pluginType) {
        if (this.nameToSupportedTypeToPluginType == null) {
            this.nameToSupportedTypeToPluginType = this.scanForPlugins();
        }
        return this.nameToSupportedTypeToPluginType.values().stream().flatMap(supportedTypeToPluginType -> supportedTypeToPluginType.entrySet().stream().filter(entry -> pluginType.equals(entry.getKey())).flatMap(entry -> Stream.of((Class)entry.getValue()))).collect(Collectors.toSet());
    }

    private Map<String, Map<Class<?>, Class<?>>> scanForPlugins() {
        Set dataPrepperPluginClasses = this.reflections.getTypesAnnotatedWith(DataPrepperPlugin.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found {} plugin classes.", (Object)dataPrepperPluginClasses.size());
            LOG.debug("Plugin classes: {}", (Object)dataPrepperPluginClasses.stream().map(Class::getName).collect(Collectors.joining(", ")));
        }
        HashMap pluginsMap = new HashMap(dataPrepperPluginClasses.size());
        for (Class concretePluginClass : dataPrepperPluginClasses) {
            this.addPossiblePluginName(pluginsMap, concretePluginClass, DataPrepperPlugin::name, name -> true);
            this.addPossiblePluginName(pluginsMap, concretePluginClass, DataPrepperPlugin::deprecatedName, deprecatedPluginName -> !deprecatedPluginName.equals(""));
            for (String alternateName : concretePluginClass.getAnnotation(DataPrepperPlugin.class).alternateNames()) {
                this.addPossiblePluginName(pluginsMap, concretePluginClass, DataPrepperPlugin2 -> alternateName, alternatePluginName -> !alternatePluginName.equals(""));
            }
        }
        return pluginsMap;
    }

    private void addPossiblePluginName(Map<String, Map<Class<?>, Class<?>>> pluginsMap, Class<?> concretePluginClass, Function<DataPrepperPlugin, String> possiblePluginNameFunction, Predicate<String> possiblePluginNamePredicate) {
        DataPrepperPlugin dataPrepperPluginAnnotation = concretePluginClass.getAnnotation(DataPrepperPlugin.class);
        String possiblePluginName = possiblePluginNameFunction.apply(dataPrepperPluginAnnotation);
        Class supportedType = dataPrepperPluginAnnotation.pluginType();
        if (possiblePluginNamePredicate.test(possiblePluginName)) {
            Map supportTypeToPluginTypeMap = pluginsMap.computeIfAbsent(possiblePluginName, k -> new HashMap());
            supportTypeToPluginTypeMap.put(supportedType, concretePluginClass);
        }
    }
}

