/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.source_crawler.coordination.scheduler;

import java.time.Duration;
import java.util.Optional;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.Crawler;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.partition.LeaderPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderScheduler
implements Runnable {
    public static final Duration DEFAULT_EXTEND_LEASE_MINUTES = Duration.ofMinutes(3L);
    private static final Logger LOG = LoggerFactory.getLogger(LeaderScheduler.class);
    private static final Duration DEFAULT_LEASE_INTERVAL = Duration.ofMinutes(1L);
    private Duration leaseInterval;
    private LeaderPartition leaderPartition;
    private final EnhancedSourceCoordinator coordinator;
    private final Crawler crawler;

    public LeaderScheduler(EnhancedSourceCoordinator coordinator, Crawler crawler) {
        this.coordinator = coordinator;
        this.leaseInterval = DEFAULT_LEASE_INTERVAL;
        this.crawler = crawler;
    }

    @Override
    public void run() {
        LOG.debug("Starting Leader Scheduler for initialization and source partition discovery");
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Optional sourcePartition;
                if (this.leaderPartition == null && (sourcePartition = this.coordinator.acquireAvailablePartition("LEADER")).isPresent()) {
                    LOG.info("Running as a LEADER node");
                    this.leaderPartition = (LeaderPartition)((Object)sourcePartition.get());
                }
                if (this.leaderPartition == null) continue;
                this.crawler.crawl(this.leaderPartition, this.coordinator);
            }
            catch (Exception e) {
                LOG.error("Exception occurred in primary scheduling loop", (Throwable)e);
            }
            finally {
                if (this.leaderPartition != null) {
                    try {
                        this.coordinator.saveProgressStateForPartition((EnhancedSourcePartition)this.leaderPartition, DEFAULT_EXTEND_LEASE_MINUTES);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to save Leader partition state. This process will retry.");
                    }
                }
                try {
                    Thread.sleep(this.leaseInterval.toMillis());
                }
                catch (InterruptedException e) {
                    LOG.info("InterruptedException occurred");
                    Thread.currentThread().interrupt();
                }
            }
        }
        LOG.warn("Quitting Leader Scheduler");
        if (this.leaderPartition != null) {
            this.coordinator.giveUpPartition((EnhancedSourcePartition)this.leaderPartition);
        }
    }

    public void setLeaseInterval(Duration leaseInterval) {
        this.leaseInterval = leaseInterval;
    }
}

