/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.sqs;

import com.linecorp.armeria.client.retry.Backoff;
import java.time.Duration;
import java.util.Collection;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SqsSinkExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(SqsSinkExecutor.class);
    private static final long INITIAL_DELAY_MS = 10L;
    private static final long MAXIMUM_DELAY_MS = Duration.ofMinutes(10L).toMillis();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Collection<Record<Event>> records) {
        if (records.isEmpty()) {
            this.lock();
            try {
                if (this.exceedsFlushTimeInterval()) {
                    this.flushBuffer();
                }
            }
            finally {
                this.unlock();
            }
            this.pushDLQList();
            return;
        }
        this.lock();
        try {
            for (Record<Event> record : records) {
                Event event = (Event)record.getData();
                try {
                    boolean reachedMaxEventsLimit;
                    long estimatedSize = this.getEstimatedSize(event);
                    if (this.exceedsMaxEventSizeThreshold(estimatedSize)) {
                        throw new RuntimeException("Event size exceeds max allowed event size");
                    }
                    if (this.willExceedMaxBatchSize(event, estimatedSize)) {
                        this.flushBuffer();
                    }
                    if (!(reachedMaxEventsLimit = this.addToBuffer(event, estimatedSize))) continue;
                    this.flushBuffer();
                }
                catch (Exception ex) {
                    this.addEventToDLQList(event, ex);
                }
            }
            this.pushDLQList();
        }
        finally {
            this.unlock();
        }
    }

    public void flushBuffer() {
        long delayMillis;
        Object failedStatus = null;
        int maxRetries = this.getMaxRetries();
        Backoff backoff = Backoff.exponential((long)10L, (long)MAXIMUM_DELAY_MS).withMaxAttempts(maxRetries);
        long startTime = System.nanoTime();
        for (int retryCount = 1; retryCount <= maxRetries && (failedStatus = this.doFlushOnce(failedStatus)) != null && (delayMillis = backoff.nextDelayMillis(retryCount)) >= 0L; ++retryCount) {
            try {
                Thread.sleep(delayMillis);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (failedStatus != null) {
            this.pushFailedObjectsToDlq(failedStatus);
        } else {
            this.recordLatency((double)System.nanoTime() - (double)startTime);
        }
    }

    public abstract void pushFailedObjectsToDlq(Object var1);

    public abstract void pushDLQList();

    public abstract void addEventToDLQList(Event var1, Throwable var2);

    public abstract Object doFlushOnce(Object var1);

    public abstract int getMaxRetries();

    public abstract boolean addToBuffer(Event var1, long var2) throws Exception;

    public abstract boolean exceedsFlushTimeInterval();

    public abstract boolean willExceedMaxBatchSize(Event var1, long var2) throws Exception;

    public abstract boolean exceedsMaxEventSizeThreshold(long var1);

    public abstract long getEstimatedSize(Event var1) throws Exception;

    public abstract void recordLatency(double var1);

    public abstract void lock();

    public abstract void unlock();
}

