/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.cloudwatch_logs;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.annotations.Experimental;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.sink.AbstractSink;
import org.opensearch.dataprepper.model.sink.Sink;
import org.opensearch.dataprepper.plugins.dlq.DlqPushHandler;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.buffer.Buffer;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.buffer.InMemoryBufferFactory;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.client.CloudWatchLogsClientFactory;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.client.CloudWatchLogsDispatcher;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.client.CloudWatchLogsMetrics;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.client.CloudWatchLogsService;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.config.AwsConfig;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.config.CloudWatchLogsSinkConfig;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.config.ThresholdConfig;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.exception.InvalidBufferTypeException;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.utils.CloudWatchLogsLimits;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;

@Experimental
@DataPrepperPlugin(name="cloudwatch_logs", pluginType=Sink.class, pluginConfigurationType=CloudWatchLogsSinkConfig.class)
public class CloudWatchLogsSink
extends AbstractSink<Record<Event>> {
    private final CloudWatchLogsService cloudWatchLogsService;
    private DlqPushHandler dlqPushHandler = null;
    private volatile boolean isInitialized;

    @DataPrepperPluginConstructor
    public CloudWatchLogsSink(PluginSetting pluginSetting, PluginMetrics pluginMetrics, PluginFactory pluginFactory, CloudWatchLogsSinkConfig cloudWatchLogsSinkConfig, AwsCredentialsSupplier awsCredentialsSupplier) {
        super(pluginSetting);
        Buffer buffer;
        AwsConfig awsConfig = cloudWatchLogsSinkConfig.getAwsConfig();
        ThresholdConfig thresholdConfig = cloudWatchLogsSinkConfig.getThresholdConfig();
        CloudWatchLogsMetrics cloudWatchLogsMetrics = new CloudWatchLogsMetrics(pluginMetrics);
        CloudWatchLogsLimits cloudWatchLogsLimits = new CloudWatchLogsLimits(thresholdConfig.getBatchSize(), thresholdConfig.getMaxEventSizeBytes(), thresholdConfig.getMaxRequestSizeBytes(), thresholdConfig.getFlushInterval());
        if (awsConfig == null && awsCredentialsSupplier == null) {
            throw new RuntimeException("Missing awsConfig and awsCredentialsSupplier");
        }
        CloudWatchLogsClient cloudWatchLogsClient = CloudWatchLogsClientFactory.createCwlClient(awsConfig, awsCredentialsSupplier);
        if (cloudWatchLogsClient == null) {
            throw new RuntimeException("cloudWatchLogsClient is null");
        }
        InMemoryBufferFactory bufferFactory = null;
        bufferFactory = new InMemoryBufferFactory();
        if (cloudWatchLogsSinkConfig.getDlq() != null) {
            String region = awsConfig.getAwsRegion().toString();
            String role = awsConfig.getAwsStsRoleArn();
            this.dlqPushHandler = new DlqPushHandler(pluginFactory, pluginSetting, pluginMetrics, cloudWatchLogsSinkConfig.getDlq(), region, role, "cloudWatchLogs");
        }
        ExecutorService executor = Executors.newFixedThreadPool(cloudWatchLogsSinkConfig.getWorkers());
        CloudWatchLogsDispatcher cloudWatchLogsDispatcher = CloudWatchLogsDispatcher.builder().cloudWatchLogsClient(cloudWatchLogsClient).cloudWatchLogsMetrics(cloudWatchLogsMetrics).dlqPushHandler(this.dlqPushHandler).logGroup(cloudWatchLogsSinkConfig.getLogGroup()).logStream(cloudWatchLogsSinkConfig.getLogStream()).retryCount(cloudWatchLogsSinkConfig.getMaxRetries()).executor(executor).build();
        try {
            buffer = bufferFactory.getBuffer();
        }
        catch (NullPointerException e) {
            throw new InvalidBufferTypeException("Error loading buffer!");
        }
        this.cloudWatchLogsService = new CloudWatchLogsService(buffer, cloudWatchLogsLimits, cloudWatchLogsDispatcher, this.dlqPushHandler);
    }

    public void doInitialize() {
        this.isInitialized = Boolean.TRUE;
    }

    public void doOutput(Collection<Record<Event>> records) {
        this.cloudWatchLogsService.processLogEvents(records);
    }

    public boolean isReady() {
        return this.isInitialized;
    }
}

