/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.encryption;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.opensearch.dataprepper.plugins.encryption.EncryptedDataKeySupplier;
import org.opensearch.dataprepper.plugins.encryption.S3BucketAndPrefix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Object;

class S3EncryptedDataKeySupplier
implements EncryptedDataKeySupplier {
    private static final Logger LOG = LoggerFactory.getLogger(S3EncryptedDataKeySupplier.class);
    private final String encryptionKeyDirectory;
    private final S3Client s3Client;
    private final S3BucketAndPrefix s3BucketAndPrefix;
    private final AtomicReference<String> encryptedDataKey = new AtomicReference();

    public S3EncryptedDataKeySupplier(S3Client s3Client, String encryptionKeyDirectory) {
        this.s3Client = s3Client;
        this.encryptionKeyDirectory = encryptionKeyDirectory;
        this.s3BucketAndPrefix = S3BucketAndPrefix.fromS3Uri(encryptionKeyDirectory);
        this.encryptedDataKey.set(this.retrieveLatestFileContent(this.s3BucketAndPrefix));
    }

    @Override
    public String retrieveValue() {
        return this.encryptedDataKey.get();
    }

    @Override
    public void refresh() {
        this.encryptedDataKey.set(this.retrieveLatestFileContent(this.s3BucketAndPrefix));
    }

    private String retrieveLatestFileContent(S3BucketAndPrefix s3BucketAndPrefix) {
        String string;
        block8: {
            String latestFileKey = this.retrieveLatestFileKey(s3BucketAndPrefix);
            GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(s3BucketAndPrefix.getBucketName()).key(latestFileKey).build();
            ResponseInputStream s3Object = this.s3Client.getObject(getObjectRequest);
            try {
                LOG.info("Object with latest key \"{}\" downloaded.", (Object)latestFileKey);
                string = IOUtils.toString((InputStream)s3Object, (Charset)StandardCharsets.UTF_8);
                if (s3Object == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s3Object != null) {
                        try {
                            s3Object.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.error("Error encountered while processing the response from Amazon S3.", (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            s3Object.close();
        }
        return string;
    }

    private String retrieveLatestFileKey(S3BucketAndPrefix s3BucketAndPrefix) {
        List fileObjects = this.getAllS3Objects(this.s3Client, s3BucketAndPrefix.getBucketName(), s3BucketAndPrefix.getPrefix()).stream().filter(s3Object -> s3Object.size() > 0L).collect(Collectors.toList());
        if (fileObjects.isEmpty()) {
            throw new IllegalStateException(String.format("No data key files found in %s.", this.encryptionKeyDirectory));
        }
        String latestFileKey = Collections.max(fileObjects, Comparator.comparing(S3Object::key)).key();
        return latestFileKey;
    }

    private List<S3Object> getAllS3Objects(S3Client s3Client, String bucketName, String prefix) {
        ListObjectsV2Response result;
        ArrayList<S3Object> allObjects = new ArrayList<S3Object>();
        String continuationToken = null;
        do {
            ListObjectsV2Request.Builder requestBuilder = ListObjectsV2Request.builder().bucket(bucketName).prefix(prefix);
            if (continuationToken != null) {
                requestBuilder.continuationToken(continuationToken);
            }
            result = s3Client.listObjectsV2((ListObjectsV2Request)requestBuilder.build());
            allObjects.addAll(result.contents());
        } while ((continuationToken = result.nextContinuationToken()) != null);
        return allObjects;
    }
}

