/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.encryption;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Size;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.hibernate.validator.constraints.time.DurationMin;
import org.opensearch.dataprepper.aws.api.AwsContextImpl;
import org.opensearch.dataprepper.aws.api.AwsCredentialsConfig;
import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.plugins.encryption.EncryptionEngineConfiguration;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

@JsonTypeName(value="kms")
class KmsEncryptionEngineConfiguration
implements EncryptionEngineConfiguration,
AwsCredentialsConfig {
    static final String S3_PREFIX = "s3://";
    private static final String AWS_IAM = "iam";
    private static final String AWS_IAM_ROLE = "role";
    static final String NAME = "kms";
    @JsonProperty(value="encryption_key")
    private String encryptionKey;
    @JsonProperty(value="encryption_key_directory")
    private String encryptionKeyDirectory;
    @JsonProperty(value="key_id")
    private String keyId;
    @JsonProperty(value="encryption_context")
    private Map<String, String> encryptionContext;
    @Valid
    @Size(min=1, message="Region cannot be empty string")
    @JsonProperty(value="region")
    private @Valid @Size(min=1, message="Region cannot be empty string") String region;
    @Valid
    @Size(min=20, max=2048, message="sts_role_arn length should be between 20 and 2048 characters")
    @JsonProperty(value="sts_role_arn")
    private @Valid @Size(min=20, max=2048, message="sts_role_arn length should be between 20 and 2048 characters") String stsRoleArn;
    @Valid
    @JsonProperty(value="rotation_interval")
    @DurationMin(hours=2L, message="Rotation interval must be at least 2 hours.")
    private @Valid @DurationMin(hours=2L, message="Rotation interval must be at least 2 hours.") Duration rotationInterval = Duration.ofDays(30L);

    KmsEncryptionEngineConfiguration() {
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public String getEncryptionKeyDirectory() {
        return this.encryptionKeyDirectory;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public Map<String, String> getEncryptionContext() {
        return this.encryptionContext;
    }

    public String getRegion() {
        return this.region;
    }

    public String getStsRoleArn() {
        return this.stsRoleArn;
    }

    public AwsCredentialsOptions toCredentialsOptions() {
        return AwsCredentialsOptions.builder().withRegion(this.region).withStsRoleArn(this.stsRoleArn).build();
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public boolean rotationEnabled() {
        return this.isEncryptionKeyInS3();
    }

    @Override
    public Duration getRotationInterval() {
        return this.rotationInterval;
    }

    public boolean isEncryptionKeyInS3() {
        return this.encryptionKeyDirectory != null && this.encryptionKeyDirectory.startsWith(S3_PREFIX);
    }

    public KmsClient createKmsClient() {
        AwsContextImpl awsContext = new AwsContextImpl((AwsCredentialsConfig)this);
        AwsCredentialsProvider awsCredentialsProvider = awsContext.getOrDefault();
        return (KmsClient)((KmsClientBuilder)((KmsClientBuilder)KmsClient.builder().credentialsProvider(awsCredentialsProvider)).region(awsContext.getRegionOrDefault())).build();
    }

    public S3Client createS3Client() {
        AwsContextImpl awsContext = new AwsContextImpl((AwsCredentialsConfig)this);
        AwsCredentialsProvider awsCredentialsProvider = awsContext.getOrDefault();
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider(awsCredentialsProvider)).region(awsContext.getRegionOrDefault())).build();
    }

    @AssertTrue(message="sts_role_arn must be an IAM Role")
    @AssertTrue(message="sts_role_arn must be an IAM Role") boolean validateStsRoleArn() {
        Arn arn = this.getArn();
        if (!AWS_IAM.equals(arn.service())) {
            return false;
        }
        Optional resourceType = arn.resource().resourceType();
        return !resourceType.isEmpty() && ((String)resourceType.get()).equals(AWS_IAM_ROLE);
    }

    @AssertTrue(message="Only one of encryption_key or encryption_key_directory must be specified.")
    @AssertTrue(message="Only one of encryption_key or encryption_key_directory must be specified.") boolean validateEncryptionKeyAndDirectory() {
        if (this.encryptionKey == null && this.encryptionKeyDirectory == null) {
            return false;
        }
        return this.encryptionKey == null || this.encryptionKeyDirectory == null;
    }

    private Arn getArn() {
        try {
            return Arn.fromString((String)this.stsRoleArn);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid ARN format for sts_role_arn. Check the format of %s", this.stsRoleArn));
        }
    }
}

