/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.encryption;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.model.encryption.EncryptionEngine;
import org.opensearch.dataprepper.plugins.encryption.EncryptedDataKeySupplier;
import org.opensearch.dataprepper.plugins.encryption.EncryptedDataKeySupplierFactory;
import org.opensearch.dataprepper.plugins.encryption.EncryptionEngineConfiguration;
import org.opensearch.dataprepper.plugins.encryption.EncryptionEngineFactory;
import org.opensearch.dataprepper.plugins.encryption.EncryptionPluginConfig;
import org.opensearch.dataprepper.plugins.encryption.EncryptionSupplier;

class DefaultEncryptionSupplier
implements EncryptionSupplier {
    private final Map<String, EncryptionEngine> encryptionEngineMap;
    private final Map<String, EncryptedDataKeySupplier> encryptedDataKeySupplierMap;
    private final EncryptionEngineFactory encryptionEngineFactory;
    private final EncryptedDataKeySupplierFactory encryptedDataKeySupplierFactory;

    public DefaultEncryptionSupplier(EncryptionPluginConfig encryptionPluginConfig, EncryptionEngineFactory encryptionEngineFactory, EncryptedDataKeySupplierFactory encryptedDataKeySupplierFactory) {
        this.encryptionEngineFactory = encryptionEngineFactory;
        this.encryptedDataKeySupplierFactory = encryptedDataKeySupplierFactory;
        this.encryptedDataKeySupplierMap = this.toEncryptedDataKeySupplierMap(encryptionPluginConfig);
        this.encryptionEngineMap = this.toEncryptionEngineMap(encryptionPluginConfig, this.encryptedDataKeySupplierMap);
    }

    @Override
    public EncryptionEngine getEncryptionEngine(String encryptionId) {
        return this.encryptionEngineMap.get(encryptionId);
    }

    @Override
    public EncryptedDataKeySupplier getEncryptedDataKeySupplier(String encryptionId) {
        return this.encryptedDataKeySupplierMap.get(encryptionId);
    }

    public Map<String, EncryptionEngine> getEncryptionEngineMap() {
        return Collections.unmodifiableMap(this.encryptionEngineMap);
    }

    public Map<String, EncryptedDataKeySupplier> getEncryptedDataKeySupplierMap() {
        return Collections.unmodifiableMap(this.encryptedDataKeySupplierMap);
    }

    private Map<String, EncryptedDataKeySupplier> toEncryptedDataKeySupplierMap(EncryptionPluginConfig encryptionPluginConfig) {
        return encryptionPluginConfig.getEncryptionConfigurationMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.encryptedDataKeySupplierFactory.createEncryptedDataKeySupplier((EncryptionEngineConfiguration)entry.getValue())));
    }

    private Map<String, EncryptionEngine> toEncryptionEngineMap(EncryptionPluginConfig encryptionPluginConfig, Map<String, EncryptedDataKeySupplier> encryptedDataKeySupplierMap) {
        return encryptionPluginConfig.getEncryptionConfigurationMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.encryptionEngineFactory.createEncryptionEngine((EncryptionEngineConfiguration)entry.getValue(), (EncryptedDataKeySupplier)encryptedDataKeySupplierMap.get(entry.getKey()))));
    }
}

