/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.encryption;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.Set;
import org.opensearch.dataprepper.plugins.encryption.EncryptionHttpHandler;
import org.opensearch.dataprepper.plugins.encryption.EncryptionRotationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultEncryptionHttpHandler
implements EncryptionHttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEncryptionHttpHandler.class);
    private final Set<EncryptionRotationHandler> encryptionRotationHandlers;

    public static DefaultEncryptionHttpHandler create(Set<EncryptionRotationHandler> encryptionRotationHandlers) {
        return new DefaultEncryptionHttpHandler(encryptionRotationHandlers);
    }

    private DefaultEncryptionHttpHandler(Set<EncryptionRotationHandler> encryptionRotationHandlers) {
        this.encryptionRotationHandlers = encryptionRotationHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String requestMethod = exchange.getRequestMethod();
        if (!requestMethod.equals("POST")) {
            exchange.sendResponseHeaders(405, 0L);
            exchange.getResponseBody().close();
            return;
        }
        String path = exchange.getRequestURI().getPath();
        try {
            for (EncryptionRotationHandler encryptionRotationHandler : this.encryptionRotationHandlers) {
                String encryptionId = encryptionRotationHandler.getEncryptionId();
                if (!path.endsWith(encryptionId)) continue;
                try {
                    LOG.info("Rotating encryptionId: {}.", (Object)encryptionId);
                    encryptionRotationHandler.handleRotation();
                    LOG.info("Finished rotating encryptionId: {}.", (Object)encryptionId);
                }
                catch (Exception e) {
                    LOG.error("Caught exception rotating encryptionId: {}.", (Object)encryptionRotationHandler.getEncryptionId(), (Object)e);
                    exchange.sendResponseHeaders(500, 0L);
                }
            }
            exchange.sendResponseHeaders(200, 0L);
        }
        finally {
            exchange.getResponseBody().close();
        }
    }
}

