/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.rpc.Status;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.grpc.GoogleGrpcExceptionHandlerFunction;
import com.linecorp.armeria.server.RequestTimeoutException;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.micrometer.core.instrument.Counter;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import org.opensearch.dataprepper.GrpcRetryInfoCalculator;
import org.opensearch.dataprepper.exceptions.BadRequestException;
import org.opensearch.dataprepper.exceptions.BufferWriteException;
import org.opensearch.dataprepper.exceptions.RequestCancelledException;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.buffer.SizeOverflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcRequestExceptionHandler
implements GoogleGrpcExceptionHandlerFunction {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcRequestExceptionHandler.class);
    static final String ARMERIA_REQUEST_TIMEOUT_MESSAGE = "Timeout waiting for request to be served. This is usually due to the buffer being full.";
    public static final String REQUEST_TIMEOUTS = "requestTimeouts";
    public static final String BAD_REQUESTS = "badRequests";
    public static final String REQUESTS_TOO_LARGE = "requestsTooLarge";
    public static final String INTERNAL_SERVER_ERROR = "internalServerError";
    private final Counter requestTimeoutsCounter;
    private final Counter badRequestsCounter;
    private final Counter requestsTooLargeCounter;
    private final Counter internalServerErrorCounter;
    private final GrpcRetryInfoCalculator retryInfoCalculator;

    public GrpcRequestExceptionHandler(PluginMetrics pluginMetrics, Duration retryInfoMinDelay, Duration retryInfoMaxDelay) {
        this.requestTimeoutsCounter = pluginMetrics.counter(REQUEST_TIMEOUTS);
        this.badRequestsCounter = pluginMetrics.counter(BAD_REQUESTS);
        this.requestsTooLargeCounter = pluginMetrics.counter(REQUESTS_TOO_LARGE);
        this.internalServerErrorCounter = pluginMetrics.counter(INTERNAL_SERVER_ERROR);
        this.retryInfoCalculator = new GrpcRetryInfoCalculator(retryInfoMinDelay, retryInfoMaxDelay);
    }

    public @Nullable Status applyStatusProto(RequestContext ctx, Throwable throwable, Metadata metadata) {
        Throwable exceptionCause = throwable instanceof BufferWriteException ? throwable.getCause() : throwable;
        return this.handleExceptions(exceptionCause);
    }

    private Status handleExceptions(Throwable e) {
        String message = e.getMessage();
        if (e instanceof RequestTimeoutException || e instanceof TimeoutException) {
            this.requestTimeoutsCounter.increment();
            return this.createStatus(e, Status.Code.RESOURCE_EXHAUSTED);
        }
        if (e instanceof SizeOverflowException) {
            this.requestsTooLargeCounter.increment();
            return this.createStatus(e, Status.Code.RESOURCE_EXHAUSTED);
        }
        if (e instanceof BadRequestException) {
            this.badRequestsCounter.increment();
            return this.createStatus(e, Status.Code.INVALID_ARGUMENT);
        }
        if (e instanceof StatusRuntimeException && (message.contains("Invalid protobuf byte sequence") || message.contains("Can't decode compressed frame"))) {
            this.badRequestsCounter.increment();
            return this.createStatus(e, Status.Code.INVALID_ARGUMENT);
        }
        if (e instanceof RequestCancelledException) {
            this.requestTimeoutsCounter.increment();
            return this.createStatus(e, Status.Code.CANCELLED);
        }
        this.internalServerErrorCounter.increment();
        LOG.error("Unexpected exception handling gRPC request", e);
        return this.createStatus(e, Status.Code.INTERNAL);
    }

    private Status createStatus(Throwable e, Status.Code code) {
        Status.Builder builder = Status.newBuilder().setCode(code.value());
        if (e instanceof RequestTimeoutException) {
            builder.setMessage(ARMERIA_REQUEST_TIMEOUT_MESSAGE);
        } else {
            builder.setMessage(e.getMessage() == null ? code.name() : e.getMessage());
        }
        if (code == Status.Code.RESOURCE_EXHAUSTED) {
            builder.addDetails(Any.pack((Message)this.retryInfoCalculator.createRetryInfo()));
        }
        return builder.build();
    }
}

