/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.pipeline.parser.rule;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.model.configuration.PipelinesDataFlowModel;
import org.opensearch.dataprepper.pipeline.parser.rule.RuleEvaluatorResult;
import org.opensearch.dataprepper.pipeline.parser.rule.RuleFileEvaluation;
import org.opensearch.dataprepper.pipeline.parser.rule.RuleStream;
import org.opensearch.dataprepper.pipeline.parser.rule.RuleTransformerModel;
import org.opensearch.dataprepper.pipeline.parser.transformer.PipelineTemplateModel;
import org.opensearch.dataprepper.pipeline.parser.transformer.TransformersFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RuleEvaluator.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final TransformersFactory transformersFactory;

    public RuleEvaluator(TransformersFactory transformersFactory) {
        this.transformersFactory = transformersFactory;
    }

    public RuleEvaluatorResult isTransformationNeeded(PipelinesDataFlowModel pipelineModel) {
        Map pipelines = pipelineModel.getPipelines();
        for (Map.Entry entry : pipelines.entrySet()) {
            try {
                String pipelineJson = OBJECT_MAPPER.writeValueAsString(entry);
                RuleFileEvaluation ruleFileEvaluation = this.evaluate(pipelineJson);
                if (!ruleFileEvaluation.getResult().booleanValue()) continue;
                String pluginName = ruleFileEvaluation.getPluginName();
                LOG.info("Applying rule {}", (Object)ruleFileEvaluation.getRuleFileName().toString());
                LOG.info("Rule for {} is evaluated true for pipelineJson {}", (Object)pluginName, (Object)pipelineJson);
                InputStream templateStream = this.transformersFactory.getPluginTemplateFileStream(pluginName);
                PipelineTemplateModel templateModel = (PipelineTemplateModel)yamlMapper.readValue(templateStream, PipelineTemplateModel.class);
                LOG.info("Template is chosen for {}", (Object)pluginName);
                return RuleEvaluatorResult.builder().withEvaluatedResult(true).withPipelineTemplateModel(templateModel).withPipelineName((String)entry.getKey()).build();
            }
            catch (JsonProcessingException e) {
                LOG.error("Error processing json");
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                LOG.error("Error reading file");
                throw new RuntimeException(e);
            }
        }
        return RuleEvaluatorResult.builder().withEvaluatedResult(false).withPipelineName(null).withPipelineTemplateModel(null).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RuleFileEvaluation evaluate(String pipelinesJson) {
        Configuration parseConfig = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build();
        RuleTransformerModel rulesModel = null;
        try {
            Collection<RuleStream> ruleStreams = this.transformersFactory.loadRules();
            Iterator<RuleStream> iterator = ruleStreams.iterator();
            while (iterator.hasNext()) {
                try (RuleStream ruleStream = iterator.next();){
                    rulesModel = (RuleTransformerModel)yamlMapper.readValue(ruleStream.getRuleStream(), RuleTransformerModel.class);
                    List<String> rules = rulesModel.getApplyWhen();
                    String pluginName = rulesModel.getPluginName();
                    boolean allRulesValid = true;
                    for (String rule : rules) {
                        try {
                            JsonNode result = (JsonNode)JsonPath.using((Configuration)parseConfig).parse(pipelinesJson).read(rule, new Predicate[0]);
                            if (result != null && result.size() != 0) continue;
                            allRulesValid = false;
                        }
                        catch (PathNotFoundException e) {
                            LOG.debug("Json Path not found for {}", (Object)ruleStream.getName());
                            allRulesValid = false;
                            break;
                        }
                    }
                    if (!allRulesValid) continue;
                    RuleFileEvaluation ruleFileEvaluation = RuleFileEvaluation.builder().withPluginName(pluginName).withRuleFileName(ruleStream.getName()).withResult(true).build();
                    return ruleFileEvaluation;
                }
            }
            return RuleFileEvaluation.builder().withPluginName(null).withRuleFileName(null).withResult(false).build();
        }
        catch (FileNotFoundException e) {
            LOG.debug("Rule File Not Found", (Throwable)e);
            return RuleFileEvaluation.builder().withPluginName(null).withRuleFileName(null).withResult(false).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

