/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.pipeline.parser;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.model.configuration.DataPrepperVersion;
import org.opensearch.dataprepper.model.configuration.PipelineExtensions;
import org.opensearch.dataprepper.model.configuration.PipelineModel;
import org.opensearch.dataprepper.model.configuration.PipelinesDataFlowModel;
import org.opensearch.dataprepper.pipeline.parser.DataPrepperDeserializationProblemHandler;
import org.opensearch.dataprepper.pipeline.parser.ParseException;
import org.opensearch.dataprepper.pipeline.parser.PipelineConfigurationReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelinesDataflowModelParser {
    private static final Logger LOG = LoggerFactory.getLogger(PipelinesDataflowModelParser.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory()).enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY).addHandler((DeserializationProblemHandler)new DataPrepperDeserializationProblemHandler());
    private final PipelineConfigurationReader pipelineConfigurationReader;

    public PipelinesDataflowModelParser(PipelineConfigurationReader pipelineConfigurationReader) {
        this.pipelineConfigurationReader = pipelineConfigurationReader;
    }

    public PipelinesDataFlowModel parseConfiguration() {
        List<PipelinesDataFlowModel> pipelinesDataFlowModels = this.parseStreamsToPipelinesDataFlowModel();
        PipelinesDataFlowModel pipelinesDataFlowModel = this.mergePipelinesDataModels(pipelinesDataFlowModels);
        return pipelinesDataFlowModel;
    }

    private void validateDataPrepperVersion(DataPrepperVersion version) {
        if (Objects.nonNull(version) && !DataPrepperVersion.getCurrentVersion().compatibleWith(version)) {
            LOG.error("The version: {} is not compatible with the current version: {}", (Object)version, (Object)DataPrepperVersion.getCurrentVersion());
            throw new ParseException(String.format("The version: %s is not compatible with the current version: %s", version, DataPrepperVersion.getCurrentVersion()));
        }
    }

    private List<PipelinesDataFlowModel> parseStreamsToPipelinesDataFlowModel() {
        return this.pipelineConfigurationReader.getPipelineConfigurationInputStreams().stream().map(this::parseStreamToPipelineDataFlowModel).collect(Collectors.toList());
    }

    private PipelinesDataFlowModel parseStreamToPipelineDataFlowModel(InputStream configurationInputStream) {
        PipelinesDataFlowModel pipelinesDataFlowModel;
        block8: {
            InputStream pipelineConfigurationInputStream = configurationInputStream;
            try {
                PipelinesDataFlowModel pipelinesDataFlowModel2 = (PipelinesDataFlowModel)OBJECT_MAPPER.readValue(pipelineConfigurationInputStream, PipelinesDataFlowModel.class);
                DataPrepperVersion version = pipelinesDataFlowModel2.getDataPrepperVersion();
                this.validateDataPrepperVersion(version);
                pipelinesDataFlowModel = pipelinesDataFlowModel2;
                if (pipelineConfigurationInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pipelineConfigurationInputStream != null) {
                        try {
                            pipelineConfigurationInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ParseException("Failed to parse the configuration", e);
                }
            }
            pipelineConfigurationInputStream.close();
        }
        return pipelinesDataFlowModel;
    }

    private PipelinesDataFlowModel mergePipelinesDataModels(List<PipelinesDataFlowModel> pipelinesDataFlowModels) {
        Map<String, PipelineModel> pipelinesDataFlowModelMap = pipelinesDataFlowModels.stream().map(PipelinesDataFlowModel::getPipelines).flatMap(pipelines -> pipelines.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        List pipelineExtensionsList = pipelinesDataFlowModels.stream().map(PipelinesDataFlowModel::getPipelineExtensions).filter(Objects::nonNull).collect(Collectors.toList());
        if (pipelineExtensionsList.size() > 1 || pipelineExtensionsList.size() == 1 && pipelinesDataFlowModels.size() > 1) {
            throw new ParseException("extension/pipeline_configurations and definition must all be defined in a single YAML file if extension/pipeline_configurations is configured.");
        }
        return pipelineExtensionsList.isEmpty() ? new PipelinesDataFlowModel(pipelinesDataFlowModelMap) : new PipelinesDataFlowModel((PipelineExtensions)pipelineExtensionsList.get(0), pipelinesDataFlowModelMap);
    }
}

