/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.validation;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Named;
import org.opensearch.dataprepper.validation.PluginError;
import org.opensearch.dataprepper.validation.PluginErrorsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class LoggingPluginErrorsHandler
implements PluginErrorsHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingPluginErrorsHandler.class);

    @Override
    public void handleErrors(Collection<PluginError> pluginErrors) {
        List allErrorMessages = pluginErrors.stream().map(PluginError::getErrorMessage).collect(Collectors.toList());
        String consolidatedErrorMessage = IntStream.range(0, allErrorMessages.size()).mapToObj(i -> i + 1 + ". " + (String)allErrorMessages.get(i)).collect(Collectors.joining("\n"));
        LOG.error(consolidatedErrorMessage);
    }
}

