/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutatestring;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.plugins.processor.mutatestring.AbstractStringProcessor;
import org.opensearch.dataprepper.plugins.processor.mutatestring.SplitStringProcessorConfig;

@DataPrepperPlugin(name="split_string", pluginType=Processor.class, pluginConfigurationType=SplitStringProcessorConfig.class)
public class SplitStringProcessor
extends AbstractStringProcessor<SplitStringProcessorConfig.Entry> {
    private final Map<String, Pattern> patternMap = new HashMap<String, Pattern>();
    private final ExpressionEvaluator expressionEvaluator;

    @DataPrepperPluginConstructor
    public SplitStringProcessor(PluginMetrics pluginMetrics, SplitStringProcessorConfig config, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics, config);
        this.expressionEvaluator = expressionEvaluator;
        for (SplitStringProcessorConfig.Entry entry : config.getEntries()) {
            if (entry.getDelimiterRegex() != null && !entry.getDelimiterRegex().isEmpty() && entry.getDelimiter() != null && !entry.getDelimiter().isEmpty()) {
                throw new IllegalArgumentException("delimiter and delimiter_regex cannot be defined at the same time");
            }
            if ((entry.getDelimiterRegex() == null || entry.getDelimiterRegex().isEmpty()) && (entry.getDelimiter() == null || entry.getDelimiter().isEmpty())) {
                throw new IllegalArgumentException("delimiter or delimiter_regex needs to be defined");
            }
            if (entry.getDelimiterRegex() != null && !entry.getDelimiterRegex().isEmpty()) {
                this.patternMap.put(entry.getDelimiterRegex(), Pattern.compile(entry.getDelimiterRegex()));
            } else {
                this.patternMap.put(entry.getDelimiter(), Pattern.compile(Pattern.quote(entry.getDelimiter())));
            }
            if (entry.getSplitWhen() == null || expressionEvaluator.isValidExpressionStatement(entry.getSplitWhen()).booleanValue()) continue;
            throw new InvalidPluginConfigurationException(String.format("split_when %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", entry.getSplitWhen()));
        }
    }

    @Override
    protected void performKeyAction(Event recordEvent, SplitStringProcessorConfig.Entry entry, String value) {
        if (Objects.nonNull(entry.getSplitWhen()) && !this.expressionEvaluator.evaluateConditional(entry.getSplitWhen(), recordEvent).booleanValue()) {
            return;
        }
        String lookup = entry.getDelimiterRegex() != null && !entry.getDelimiterRegex().isEmpty() ? entry.getDelimiterRegex() : entry.getDelimiter();
        Pattern pattern = this.patternMap.get(lookup);
        String[] splitValue = pattern.split(value);
        recordEvent.put(entry.getSource(), (Object)splitValue);
    }

    @Override
    protected EventKey getKey(SplitStringProcessorConfig.Entry entry) {
        return entry.getSource();
    }
}

