/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip.processor;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import org.opensearch.dataprepper.model.annotations.ExampleValues;
import org.opensearch.dataprepper.plugins.geoip.processor.EntryConfig;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>geoip</code> processor enriches events with geographic information extracted from IP addresses contained in the events.")
public class GeoIPProcessorConfig {
    @Valid
    @NotNull
    @Size(min=1)
    @JsonProperty(value="entries")
    @JsonPropertyDescription(value="The list of entries for enrichment. Each entry provides a source field with an IP address along with a target for the enriched geolocation data.")
    private @Valid @NotNull @Size(min=1) List<EntryConfig> entries;
    @JsonProperty(value="tags_on_engine_failure")
    @JsonPropertyDescription(value="The tags to add to the event metadata if the <code>geoip</code> processor is unable to enrich an event due to an engine failure.")
    private List<String> tagsOnEngineFailure;
    @JsonProperty(value="tags_on_ip_not_found")
    @JsonPropertyDescription(value="The tags to add to the event metadata if the <code>geoip</code> processor is unable to find a location for a valid IP address.")
    private List<String> tagsOnIPNotFound;
    @JsonProperty(value="tags_on_no_valid_ip")
    @JsonPropertyDescription(value="The tags to add to the event metadata if the source field is not a valid IP address. A source field may not be valid because it is incorrectly formatted or is the loopback/localhost IP address.")
    private List<String> tagsOnNoValidIp;
    @JsonProperty(value="geoip_when")
    @JsonPropertyDescription(value="A <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">conditional expression</a> such as <code>/srcaddr != \"8.8.8.8\"</code>. If specified, the <code>geoip</code> processor will only run on events when the expression evaluates to true. ")
    @ExampleValues(value={@ExampleValues.Example(value="/srcaddr != \"8.8.8.8\"", description="The processor will only match when the source IP is equivalent to 8.8.8.8.")})
    private String whenCondition;

    public List<EntryConfig> getEntries() {
        return this.entries;
    }

    public List<String> getTagsOnEngineFailure() {
        return this.tagsOnEngineFailure;
    }

    public List<String> getTagsOnIPNotFound() {
        return this.tagsOnIPNotFound;
    }

    public List<String> getTagsOnNoValidIp() {
        return this.tagsOnNoValidIp;
    }

    public String getWhenCondition() {
        return this.whenCondition;
    }
}

