/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip.processor;

import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.dataprepper.plugins.geoip.GeoIPDatabase;
import org.opensearch.dataprepper.plugins.geoip.GeoIPField;
import org.opensearch.dataprepper.plugins.geoip.extension.api.GeoIPDatabaseReader;

class BatchGeoIPDatabaseReader
implements GeoIPDatabaseReader {
    private final GeoIPDatabaseReader delegate;
    private final Map<GeoDataInput, Map<String, Object>> geoDataCache = new HashMap<GeoDataInput, Map<String, Object>>();
    private Boolean isExpired = null;

    BatchGeoIPDatabaseReader(GeoIPDatabaseReader delegate) {
        this.delegate = delegate;
    }

    static BatchGeoIPDatabaseReader decorate(GeoIPDatabaseReader delegate) {
        if (delegate == null) {
            return null;
        }
        return new BatchGeoIPDatabaseReader(delegate);
    }

    @Override
    public Map<String, Object> getGeoData(InetAddress inetAddress, Collection<GeoIPField> fields, Collection<GeoIPDatabase> geoIPDatabases) {
        GeoDataInput geoDataInput = new GeoDataInput(inetAddress, fields, geoIPDatabases);
        return this.geoDataCache.computeIfAbsent(geoDataInput, unused -> this.delegate.getGeoData(inetAddress, fields, geoIPDatabases));
    }

    @Override
    public boolean isExpired() {
        if (this.isExpired == null) {
            this.isExpired = this.delegate.isExpired();
        }
        return this.isExpired;
    }

    @Override
    public void retain() {
        throw new UnsupportedOperationException("GeoIP processor should not call retain. This is a coding error.");
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    private static class GeoDataInput {
        final InetAddress inetAddress;
        final Collection<GeoIPField> fields;
        final Collection<GeoIPDatabase> geoIPDatabases;

        private GeoDataInput(InetAddress inetAddress, Collection<GeoIPField> fields, Collection<GeoIPDatabase> geoIPDatabases) {
            this.inetAddress = inetAddress;
            this.fields = fields;
            this.geoIPDatabases = geoIPDatabases;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GeoDataInput that = (GeoDataInput)o;
            return Objects.equals(this.inetAddress, that.inetAddress) && Objects.equals(this.fields, that.fields) && Objects.equals(this.geoIPDatabases, that.geoIPDatabases);
        }

        public int hashCode() {
            return Objects.hash(this.inetAddress, this.fields, this.geoIPDatabases);
        }
    }
}

