/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip.extension;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Postal;
import com.maxmind.geoip2.record.RepresentedCountry;
import com.maxmind.geoip2.record.Subdivision;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.dataprepper.plugins.geoip.GeoIPDatabase;
import org.opensearch.dataprepper.plugins.geoip.GeoIPField;
import org.opensearch.dataprepper.plugins.geoip.exception.DatabaseReaderInitializationException;
import org.opensearch.dataprepper.plugins.geoip.exception.EngineFailureException;
import org.opensearch.dataprepper.plugins.geoip.exception.EnrichFailedException;
import org.opensearch.dataprepper.plugins.geoip.exception.NoValidDatabaseFoundException;
import org.opensearch.dataprepper.plugins.geoip.extension.api.GeoIPDatabaseReader;
import org.opensearch.dataprepper.plugins.geoip.extension.databasedownload.DatabaseReaderBuilder;
import org.opensearch.dataprepper.plugins.geoip.extension.databasedownload.GeoIPFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GeoLite2DatabaseReader
implements GeoIPDatabaseReader,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(GeoLite2DatabaseReader.class);
    static final String MAXMIND_GEOLITE2_DATABASE_TYPE = "geolite2";
    private final DatabaseReaderBuilder databaseReaderBuilder;
    private final String databasePath;
    private final int cacheSize;
    private final AtomicBoolean isCountryDatabaseExpired;
    private final AtomicBoolean isCityDatabaseExpired;
    private final AtomicBoolean isAsnDatabaseExpired;
    private final GeoIPFileManager geoIPFileManager;
    private DatabaseReader cityDatabaseReader;
    private DatabaseReader countryDatabaseReader;
    private DatabaseReader asnDatabaseReader;
    private Instant cityDatabaseBuildDate;
    private Instant countryDatabaseBuildDate;
    private Instant asnDatabaseBuildDate;

    public GeoLite2DatabaseReader(DatabaseReaderBuilder databaseReaderBuilder, GeoIPFileManager geoIPFileManager, String databasePath, int cacheSize) {
        this.databaseReaderBuilder = databaseReaderBuilder;
        this.geoIPFileManager = geoIPFileManager;
        this.databasePath = databasePath;
        this.cacheSize = cacheSize;
        this.isCountryDatabaseExpired = new AtomicBoolean(false);
        this.isCityDatabaseExpired = new AtomicBoolean(false);
        this.isAsnDatabaseExpired = new AtomicBoolean(false);
        this.buildDatabaseReaders();
    }

    private void buildDatabaseReaders() {
        try {
            Optional<String> cityDatabaseName = this.getDatabaseName("geolite2-city", this.databasePath, MAXMIND_GEOLITE2_DATABASE_TYPE);
            Optional<String> countryDatabaseName = this.getDatabaseName("geolite2-country", this.databasePath, MAXMIND_GEOLITE2_DATABASE_TYPE);
            Optional<String> asnDatabaseName = this.getDatabaseName("geolite2-asn", this.databasePath, MAXMIND_GEOLITE2_DATABASE_TYPE);
            if (cityDatabaseName.isPresent()) {
                this.cityDatabaseReader = this.databaseReaderBuilder.buildReader(Path.of(this.databasePath + File.separator + cityDatabaseName.get(), new String[0]), this.cacheSize);
                this.cityDatabaseBuildDate = this.cityDatabaseReader.getMetadata().getBuildDate().toInstant();
            }
            if (countryDatabaseName.isPresent()) {
                this.countryDatabaseReader = this.databaseReaderBuilder.buildReader(Path.of(this.databasePath + File.separator + countryDatabaseName.get(), new String[0]), this.cacheSize);
                this.countryDatabaseBuildDate = this.countryDatabaseReader.getMetadata().getBuildDate().toInstant();
            }
            if (asnDatabaseName.isPresent()) {
                this.asnDatabaseReader = this.databaseReaderBuilder.buildReader(Path.of(this.databasePath + File.separator + asnDatabaseName.get(), new String[0]), this.cacheSize);
                this.asnDatabaseBuildDate = this.asnDatabaseReader.getMetadata().getBuildDate().toInstant();
            }
        }
        catch (IOException ex) {
            throw new DatabaseReaderInitializationException("Exception while creating GeoLite2 DatabaseReaders due to: " + ex.getMessage());
        }
        if (this.cityDatabaseReader == null && this.countryDatabaseReader == null && this.asnDatabaseReader == null) {
            throw new NoValidDatabaseFoundException("Unable to initialize any GeoLite2 database, make sure they are valid.");
        }
    }

    @Override
    public Map<String, Object> getGeoData(InetAddress inetAddress, Collection<GeoIPField> fields, Collection<GeoIPDatabase> geoIPDatabases) {
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        try {
            if (this.countryDatabaseReader != null && !this.isCountryDatabaseExpired.get() && geoIPDatabases.contains((Object)GeoIPDatabase.COUNTRY)) {
                Optional countryResponse = this.countryDatabaseReader.tryCountry(inetAddress);
                countryResponse.ifPresent(response -> this.processCountryResponse((CountryResponse)response, (Map<String, Object>)geoData, fields));
            }
            if (this.cityDatabaseReader != null && !this.isCityDatabaseExpired.get() && geoIPDatabases.contains((Object)GeoIPDatabase.CITY)) {
                Optional cityResponse = this.cityDatabaseReader.tryCity(inetAddress);
                cityResponse.ifPresent(response -> this.processCityResponse((CityResponse)response, (Map<String, Object>)geoData, fields, geoIPDatabases));
            }
            if (this.asnDatabaseReader != null && !this.isAsnDatabaseExpired.get() && geoIPDatabases.contains((Object)GeoIPDatabase.ASN)) {
                Optional asnResponse = this.asnDatabaseReader.tryAsn(inetAddress);
                asnResponse.ifPresent(response -> this.processAsnResponse((AsnResponse)response, (Map<String, Object>)geoData, fields));
            }
        }
        catch (GeoIp2Exception e) {
            throw new EnrichFailedException("Address not found in database.");
        }
        catch (IOException e) {
            throw new EngineFailureException("Failed to close database readers gracefully. It can be due to expired databases.");
        }
        return geoData;
    }

    private void processCountryResponse(CountryResponse countryResponse, Map<String, Object> geoData, Collection<GeoIPField> fields) {
        Continent continent = countryResponse.getContinent();
        Country country = countryResponse.getCountry();
        Country registeredCountry = countryResponse.getRegisteredCountry();
        RepresentedCountry representedCountry = countryResponse.getRepresentedCountry();
        this.extractContinentFields(continent, geoData, fields);
        this.extractCountryFields(country, geoData, fields, false);
        this.extractRegisteredCountryFields(registeredCountry, geoData, fields);
        this.extractRepresentedCountryFields(representedCountry, geoData, fields);
    }

    private void processCityResponse(CityResponse cityResponse, Map<String, Object> geoData, Collection<GeoIPField> fields, Collection<GeoIPDatabase> geoIPDatabases) {
        if (!geoIPDatabases.contains((Object)GeoIPDatabase.COUNTRY)) {
            Continent continent = cityResponse.getContinent();
            Country country = cityResponse.getCountry();
            Country registeredCountry = cityResponse.getRegisteredCountry();
            RepresentedCountry representedCountry = cityResponse.getRepresentedCountry();
            this.extractContinentFields(continent, geoData, fields);
            this.extractCountryFields(country, geoData, fields, false);
            this.extractRegisteredCountryFields(registeredCountry, geoData, fields);
            this.extractRepresentedCountryFields(representedCountry, geoData, fields);
        }
        City city = cityResponse.getCity();
        Location location = cityResponse.getLocation();
        Postal postal = cityResponse.getPostal();
        Subdivision mostSpecificSubdivision = cityResponse.getMostSpecificSubdivision();
        Subdivision leastSpecificSubdivision = cityResponse.getLeastSpecificSubdivision();
        this.extractCityFields(city, geoData, fields, false);
        this.extractLocationFields(location, geoData, fields);
        this.extractPostalFields(postal, geoData, fields, false);
        this.extractMostSpecifiedSubdivisionFields(mostSpecificSubdivision, geoData, fields, false);
        this.extractLeastSpecifiedSubdivisionFields(leastSpecificSubdivision, geoData, fields, false);
    }

    private void processAsnResponse(AsnResponse asnResponse, Map<String, Object> geoData, Collection<GeoIPField> fields) {
        this.extractAsnFields(asnResponse, geoData, fields);
    }

    @Override
    public void retain() {
    }

    @Override
    public void close() {
        this.closeReaders();
    }

    @Override
    public boolean isExpired() {
        Instant instant = Instant.now();
        return this.isDatabaseExpired(instant, this.countryDatabaseReader, this.isCountryDatabaseExpired, this.countryDatabaseBuildDate, "geolite2-country") && this.isDatabaseExpired(instant, this.cityDatabaseReader, this.isCityDatabaseExpired, this.cityDatabaseBuildDate, "geolite2-city") && this.isDatabaseExpired(instant, this.asnDatabaseReader, this.isAsnDatabaseExpired, this.asnDatabaseBuildDate, "geolite2-asn");
    }

    private boolean isDatabaseExpired(Instant instant, DatabaseReader databaseReader, AtomicBoolean isDatabaseExpired, Instant databaseBuildDate, String databaseName) {
        if (databaseReader == null) {
            return true;
        }
        if (isDatabaseExpired.get()) {
            return true;
        }
        if (databaseBuildDate.plus(MAX_EXPIRY_DURATION).isBefore(instant)) {
            isDatabaseExpired.set(true);
            this.closeReader(databaseReader, databaseName);
        }
        return isDatabaseExpired.get();
    }

    private void closeReaders() {
        try {
            if (this.cityDatabaseReader != null) {
                this.cityDatabaseReader.close();
            }
            if (this.countryDatabaseReader != null) {
                this.countryDatabaseReader.close();
            }
            if (this.asnDatabaseReader != null) {
                this.asnDatabaseReader.close();
            }
        }
        catch (IOException e) {
            LOG.debug("Failed to close Maxmind database readers due to: {}. Force closing readers.", (Object)e.getMessage());
        }
        File file = new File(this.databasePath);
        this.geoIPFileManager.deleteDirectory(file);
    }

    private void closeReader(DatabaseReader databaseReader, String databaseName) {
        try {
            if (databaseReader != null) {
                databaseReader.close();
            }
        }
        catch (IOException e) {
            LOG.debug("Failed to close Maxmind database readers due to: {}. Force closing readers.", (Object)e.getMessage());
        }
        Optional<String> fileName = this.getDatabaseName(databaseName, this.databasePath, MAXMIND_GEOLITE2_DATABASE_TYPE);
        fileName.ifPresent(response -> {
            File file = new File(this.databasePath + File.separator + response);
            this.geoIPFileManager.deleteFile(file);
        });
    }
}

