/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.internal.batchmanager;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.internal.batchmanager.RequestBatchManager;
import software.amazon.awssdk.services.sqs.internal.batchmanager.ResponseBatchConfiguration;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResponse;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.NumericUtils;

@SdkInternalApi
public class ReceiveSqsMessageHelper {
    private static final Logger log = Logger.loggerFor(ReceiveSqsMessageHelper.class);
    private final String queueUrl;
    private final SqsAsyncClient asyncClient;
    private final Duration visibilityTimeout;
    private final ResponseBatchConfiguration config;
    private volatile Throwable exception;
    private Queue<Message> messages = new ConcurrentLinkedQueue<Message>();
    private volatile long visibilityDeadlineNano;

    public ReceiveSqsMessageHelper(String queueUrl, SqsAsyncClient asyncClient, Duration visibilityTimeout, ResponseBatchConfiguration config) {
        this.queueUrl = queueUrl;
        this.asyncClient = asyncClient;
        this.visibilityTimeout = visibilityTimeout;
        this.config = config;
    }

    public CompletableFuture<ReceiveSqsMessageHelper> asyncReceiveMessage() {
        AwsRequest.Builder request = ReceiveMessageRequest.builder().queueUrl(this.queueUrl).maxNumberOfMessages(this.config.maxBatchItems()).overrideConfiguration(o -> o.applyMutation(RequestBatchManager.USER_AGENT_APPLIER));
        if (!CollectionUtils.isNullOrEmpty(this.config.messageSystemAttributeNames())) {
            request.messageSystemAttributeNames(this.config.messageSystemAttributeNames());
        }
        if (!CollectionUtils.isNullOrEmpty(this.config.receiveMessageAttributeNames())) {
            request.messageAttributeNames(this.config.receiveMessageAttributeNames());
        }
        request.visibilityTimeout(NumericUtils.saturatedCast((long)this.visibilityTimeout.getSeconds()));
        try {
            CompletionStage completionStage = this.asyncClient.receiveMessage((ReceiveMessageRequest)((Object)request.build())).handle((response, throwable) -> {
                if (throwable != null) {
                    this.exception = throwable;
                } else {
                    this.messages.addAll(response.messages());
                }
                return this;
            });
            return completionStage;
        }
        finally {
            this.visibilityDeadlineNano = System.nanoTime() + this.visibilityTimeout.toNanos();
        }
    }

    public boolean isEmpty() {
        return this.messages == null || this.messages.isEmpty();
    }

    public Throwable getException() {
        return this.exception;
    }

    public Message removeMessage() {
        if (this.isExpired()) {
            this.clear();
            return null;
        }
        return this.messages.poll();
    }

    private boolean isExpired() {
        return System.nanoTime() > this.visibilityDeadlineNano;
    }

    public void clear() {
        CompletableFuture<ChangeMessageVisibilityBatchResponse> nackedMessages;
        if (!this.isEmpty() && (nackedMessages = this.nackMessages()) != null) {
            nackedMessages.exceptionally(throwable -> {
                log.warn(() -> String.format("Failed to reset the visibility timeout of unprocessed messages for queueUrl: %s. As a result, these unprocessed messages will remain invisible in the queue for the duration of the visibility timeout (%s).", this.queueUrl, this.visibilityTimeout), throwable);
                return null;
            });
        }
    }

    private CompletableFuture<ChangeMessageVisibilityBatchResponse> nackMessages() {
        if (this.messages == null || this.messages.isEmpty()) {
            return null;
        }
        List<ChangeMessageVisibilityBatchRequestEntry> entries = IntStream.range(0, this.messages.size()).mapToObj(i -> (ChangeMessageVisibilityBatchRequestEntry)ChangeMessageVisibilityBatchRequestEntry.builder().id(String.valueOf(i)).receiptHandle(Objects.requireNonNull(this.messages.poll()).receiptHandle()).visibilityTimeout(0).build()).collect(Collectors.toList());
        ChangeMessageVisibilityBatchRequest batchRequest = (ChangeMessageVisibilityBatchRequest)((Object)ChangeMessageVisibilityBatchRequest.builder().queueUrl(this.queueUrl).entries(entries).overrideConfiguration(o -> o.applyMutation(RequestBatchManager.USER_AGENT_APPLIER)).build());
        return this.asyncClient.changeMessageVisibilityBatch(batchRequest);
    }

    @SdkTestInternalApi
    public Integer messagesSize() {
        return this.messages != null ? this.messages.size() : 0;
    }
}

