/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DbMetadata {
    static final String DB_IDENTIFIER_KEY = "dbIdentifier";
    static final String ENDPOINT_KEY = "endpoint";
    static final String PORT_KEY = "port";
    static final String READER_ENDPOINT_KEY = "readerEndpoint";
    static final String READER_PORT_KEY = "readerPort";
    private final String dbIdentifier;
    private final String endpoint;
    private final int port;
    private final String readerEndpoint;
    private final int readerPort;

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(DB_IDENTIFIER_KEY, this.dbIdentifier);
        map.put(ENDPOINT_KEY, this.endpoint);
        map.put(PORT_KEY, this.port);
        map.put(READER_ENDPOINT_KEY, this.readerEndpoint);
        map.put(READER_PORT_KEY, this.readerPort);
        return Collections.unmodifiableMap(map);
    }

    public static DbMetadata fromMap(Map<String, Object> map) {
        return new DbMetadata((String)map.get(DB_IDENTIFIER_KEY), (String)map.get(ENDPOINT_KEY), (Integer)map.get(PORT_KEY), (String)map.get(READER_ENDPOINT_KEY), (Integer)map.get(READER_PORT_KEY));
    }

    public static DbMetadataBuilder builder() {
        return new DbMetadataBuilder();
    }

    public String getDbIdentifier() {
        return this.dbIdentifier;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public int getPort() {
        return this.port;
    }

    public String getReaderEndpoint() {
        return this.readerEndpoint;
    }

    public int getReaderPort() {
        return this.readerPort;
    }

    public DbMetadata(String dbIdentifier, String endpoint, int port, String readerEndpoint, int readerPort) {
        this.dbIdentifier = dbIdentifier;
        this.endpoint = endpoint;
        this.port = port;
        this.readerEndpoint = readerEndpoint;
        this.readerPort = readerPort;
    }

    public static class DbMetadataBuilder {
        private String dbIdentifier;
        private String endpoint;
        private int port;
        private String readerEndpoint;
        private int readerPort;

        DbMetadataBuilder() {
        }

        public DbMetadataBuilder dbIdentifier(String dbIdentifier) {
            this.dbIdentifier = dbIdentifier;
            return this;
        }

        public DbMetadataBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public DbMetadataBuilder port(int port) {
            this.port = port;
            return this;
        }

        public DbMetadataBuilder readerEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
            return this;
        }

        public DbMetadataBuilder readerPort(int readerPort) {
            this.readerPort = readerPort;
            return this;
        }

        public DbMetadata build() {
            return new DbMetadata(this.dbIdentifier, this.endpoint, this.port, this.readerEndpoint, this.readerPort);
        }

        public String toString() {
            return "DbMetadata.DbMetadataBuilder(dbIdentifier=" + this.dbIdentifier + ", endpoint=" + this.endpoint + ", port=" + this.port + ", readerEndpoint=" + this.readerEndpoint + ", readerPort=" + this.readerPort + ")";
        }
    }
}

