/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.coordination.partition;

import java.util.Optional;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.rds.coordination.state.ResyncProgressState;

public class ResyncPartition
extends EnhancedSourcePartition<ResyncProgressState> {
    public static final String PARTITION_TYPE = "RESYNC";
    private final String database;
    private final String table;
    private final long timestamp;
    private final PartitionKeyInfo partitionKeyInfo;
    private final ResyncProgressState state;

    public ResyncPartition(String database, String table, long timestamp, ResyncProgressState state) {
        this.database = database;
        this.table = table;
        this.timestamp = timestamp;
        this.partitionKeyInfo = new PartitionKeyInfo(database, table, timestamp);
        this.state = state;
    }

    public ResyncPartition(SourcePartitionStoreItem sourcePartitionStoreItem) {
        this.setSourcePartitionStoreItem(sourcePartitionStoreItem);
        this.partitionKeyInfo = PartitionKeyInfo.fromString(sourcePartitionStoreItem.getSourcePartitionKey());
        this.database = this.partitionKeyInfo.getDatabase();
        this.table = this.partitionKeyInfo.getTable();
        this.timestamp = this.partitionKeyInfo.getTimestamp();
        this.state = (ResyncProgressState)this.convertStringToPartitionProgressState(ResyncProgressState.class, sourcePartitionStoreItem.getPartitionProgressState());
    }

    public String getPartitionType() {
        return PARTITION_TYPE;
    }

    public String getPartitionKey() {
        return this.partitionKeyInfo.toString();
    }

    public Optional<ResyncProgressState> getProgressState() {
        if (this.state != null) {
            return Optional.of(this.state);
        }
        return Optional.empty();
    }

    public PartitionKeyInfo getPartitionKeyInfo() {
        return this.partitionKeyInfo;
    }

    public static class PartitionKeyInfo {
        private final String database;
        private final String table;
        private final long timestamp;

        private PartitionKeyInfo(String database, String table, long timestamp) {
            this.database = database;
            this.table = table;
            this.timestamp = timestamp;
        }

        private static PartitionKeyInfo fromString(String partitionKey) {
            String[] keySplits = partitionKey.split("\\|");
            if (keySplits.length != 3) {
                throw new IllegalArgumentException("Invalid partition key: " + partitionKey);
            }
            return new PartitionKeyInfo(keySplits[0], keySplits[1], Long.parseLong(keySplits[2]));
        }

        public String toString() {
            return this.database + "|" + this.table + "|" + this.timestamp;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getTable() {
            return this.table;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

