/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds;

import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.plugins.source.rds.RdsSourceConfig;
import org.opensearch.dataprepper.plugins.source.rds.configuration.AwsAuthenticationConfig;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.RdsClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class ClientFactory {
    private final AwsAuthenticationConfig awsAuthenticationConfig;
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final RdsSourceConfig sourceConfig;

    public ClientFactory(AwsCredentialsSupplier awsCredentialsSupplier, RdsSourceConfig sourceConfig) {
        this.awsAuthenticationConfig = sourceConfig.getAwsAuthenticationConfig();
        this.awsCredentialsProvider = awsCredentialsSupplier.getProvider(AwsCredentialsOptions.builder().withRegion(this.awsAuthenticationConfig.getAwsRegion()).withStsRoleArn(this.awsAuthenticationConfig.getAwsStsRoleArn()).withStsExternalId(this.awsAuthenticationConfig.getAwsStsExternalId()).withStsHeaderOverrides(this.awsAuthenticationConfig.getAwsStsHeaderOverrides()).build());
        this.sourceConfig = sourceConfig;
    }

    public RdsClient buildRdsClient() {
        return (RdsClient)((RdsClientBuilder)((RdsClientBuilder)RdsClient.builder().region(this.awsAuthenticationConfig.getAwsRegion())).credentialsProvider(this.awsCredentialsProvider)).build();
    }

    public S3Client buildS3Client() {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(this.getS3ClientRegion())).credentialsProvider(this.awsCredentialsProvider)).build();
    }

    private Region getS3ClientRegion() {
        if (this.sourceConfig.getS3Region() != null) {
            return this.sourceConfig.getS3Region();
        }
        return this.awsAuthenticationConfig.getAwsRegion();
    }
}

