/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3.ownership;

import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.plugins.sink.s3.S3SinkConfig;
import org.opensearch.dataprepper.plugins.sink.s3.ownership.BucketOwnerProvider;
import org.opensearch.dataprepper.plugins.sink.s3.ownership.MappedBucketOwnerProvider;
import org.opensearch.dataprepper.plugins.sink.s3.ownership.NoOwnershipBucketOwnerProvider;
import org.opensearch.dataprepper.plugins.sink.s3.ownership.StaticBucketOwnerProvider;
import software.amazon.awssdk.arns.Arn;

public class ConfigBucketOwnerProviderFactory {
    public BucketOwnerProvider createBucketOwnerProvider(S3SinkConfig s3SinkConfig) {
        if (s3SinkConfig.getDefaultBucketOwner() == null && s3SinkConfig.getBucketOwners() == null) {
            return new NoOwnershipBucketOwnerProvider();
        }
        StaticBucketOwnerProvider staticBucketOwnerProvider = this.getStaticBucketOwnerProvider(s3SinkConfig);
        if (s3SinkConfig.getBucketOwners() != null && !s3SinkConfig.getBucketOwners().isEmpty()) {
            return new MappedBucketOwnerProvider(s3SinkConfig.getBucketOwners(), staticBucketOwnerProvider);
        }
        return staticBucketOwnerProvider;
    }

    private StaticBucketOwnerProvider getStaticBucketOwnerProvider(S3SinkConfig s3SinkConfig) {
        String accountId;
        if (s3SinkConfig.getDefaultBucketOwner() != null) {
            accountId = s3SinkConfig.getDefaultBucketOwner();
        } else if (s3SinkConfig.getAwsAuthenticationOptions() != null && s3SinkConfig.getAwsAuthenticationOptions().getAwsStsRoleArn() != null) {
            accountId = this.extractStsRoleArnAccountId(s3SinkConfig);
        } else {
            throw new InvalidPluginConfigurationException("The S3 sink is unable to determine a bucket owner. Configure the default_bucket_owner for the account Id that owns the bucket. You may also want to configure bucket_owners if you write to S3 buckets in different accounts.");
        }
        return new StaticBucketOwnerProvider(accountId);
    }

    private String extractStsRoleArnAccountId(S3SinkConfig s3SinkConfig) {
        Arn roleArn = Arn.fromString((String)s3SinkConfig.getAwsAuthenticationOptions().getAwsStsRoleArn());
        if (roleArn.accountId().isPresent()) {
            return (String)roleArn.accountId().get();
        }
        throw new RuntimeException(String.format("Unable to extract account id from sts_role_arn %s", s3SinkConfig.getAwsAuthenticationOptions().getAwsStsRoleArn()));
    }
}

