/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3.accumulator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.time.StopWatch;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.Buffer;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.BufferUtilities;
import org.opensearch.dataprepper.plugins.sink.s3.ownership.BucketOwnerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.services.s3.S3AsyncClient;

public class LocalFileBuffer
implements Buffer {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileBuffer.class);
    private final OutputStream outputStream;
    private final S3AsyncClient s3Client;
    private final Supplier<String> bucketSupplier;
    private final Supplier<String> keySupplier;
    private final BucketOwnerProvider bucketOwnerProvider;
    private int eventCount;
    private final StopWatch watch;
    private final File localFile;
    private boolean isCodecStarted;
    private String bucket;
    private String key;
    private String defaultBucket;

    LocalFileBuffer(File tempFile, S3AsyncClient s3Client, Supplier<String> bucketSupplier, Supplier<String> keySupplier, String defaultBucket, BucketOwnerProvider bucketOwnerProvider) throws FileNotFoundException {
        this.localFile = tempFile;
        this.outputStream = new BufferedOutputStream(new FileOutputStream(tempFile), 32768);
        this.s3Client = s3Client;
        this.bucketSupplier = bucketSupplier;
        this.keySupplier = keySupplier;
        this.eventCount = 0;
        this.watch = new StopWatch();
        this.watch.start();
        this.isCodecStarted = false;
        this.defaultBucket = defaultBucket;
        this.bucketOwnerProvider = bucketOwnerProvider;
    }

    @Override
    public long getSize() {
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            LOG.error("An exception occurred while flushing data to buffered output stream :", (Throwable)e);
        }
        return this.localFile.length();
    }

    @Override
    public int getEventCount() {
        return this.eventCount;
    }

    @Override
    public Duration getDuration() {
        return Duration.ofMillis(this.watch.getTime(TimeUnit.MILLISECONDS));
    }

    @Override
    public Optional<CompletableFuture<?>> flushToS3(Consumer<Boolean> consumeOnCompletion, Consumer<Throwable> consumeOnException) {
        this.flushAndCloseStream();
        CompletionStage putObjectResponseCompletableFuture = BufferUtilities.putObjectOrSendToDefaultBucket(this.s3Client, AsyncRequestBody.fromFile((File)this.localFile), consumeOnCompletion, consumeOnException, this.getKey(), this.getBucket(), this.defaultBucket, null, this.bucketOwnerProvider).whenComplete((response, throwable) -> this.removeTemporaryFile());
        return Optional.of(putObjectResponseCompletableFuture);
    }

    protected void flushAndCloseStream() {
        try {
            this.outputStream.flush();
            this.outputStream.close();
        }
        catch (IOException e) {
            LOG.error("An exception occurred while flushing data to buffered output stream :", (Throwable)e);
        }
    }

    protected void removeTemporaryFile() {
        if (this.localFile != null) {
            try {
                Files.deleteIfExists(Paths.get(this.localFile.toString(), new String[0]));
            }
            catch (IOException e) {
                LOG.error("Unable to delete Local file {}", (Object)this.localFile, (Object)e);
            }
        }
    }

    @Override
    public void setEventCount(int eventCount) {
        this.eventCount = eventCount;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    private Map<String, String> getMetadata() {
        return null;
    }

    private String getBucket() {
        if (this.bucket == null) {
            this.bucket = this.bucketSupplier.get();
        }
        return this.bucket;
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            this.key = this.keySupplier.get();
        }
        return this.key;
    }
}

