/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3.accumulator;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.Buffer;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.BufferFactory;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.CodecBuffer;
import org.opensearch.dataprepper.plugins.sink.s3.codec.BufferedCodec;
import org.opensearch.dataprepper.plugins.sink.s3.ownership.BucketOwnerProvider;
import software.amazon.awssdk.services.s3.S3AsyncClient;

public class CodecBufferFactory
implements BufferFactory {
    private final BufferFactory innerBufferFactory;
    private final BufferedCodec bufferedCodec;

    public CodecBufferFactory(BufferFactory innerBufferFactory, BufferedCodec codec) {
        this.innerBufferFactory = innerBufferFactory;
        this.bufferedCodec = codec;
    }

    @Override
    public Buffer getBuffer(S3AsyncClient s3Client, Supplier<String> bucketSupplier, Supplier<String> keySupplier, String defaultBucket, Function<Integer, Map<String, String>> metadataSupplier, BucketOwnerProvider bucketOwnerProvider) {
        Buffer innerBuffer = this.innerBufferFactory.getBuffer(s3Client, bucketSupplier, keySupplier, defaultBucket, metadataSupplier, bucketOwnerProvider);
        return new CodecBuffer(innerBuffer, this.bufferedCodec);
    }
}

